% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_map.R
\name{mf_map}
\alias{mf_map}
\title{Plot a map}
\usage{
mf_map(
  x,
  var,
  type = "base",
  breaks,
  nbreaks,
  pal,
  alpha,
  rev,
  inches,
  val_max,
  symbol,
  col,
  lwd_max,
  val_order,
  pch,
  cex,
  border,
  lwd,
  col_na,
  cex_na,
  pch_na,
  expandBB,
  add,
  leg_pos,
  leg_title,
  leg_title_cex,
  leg_val_cex,
  leg_val_rnd,
  leg_no_data,
  leg_frame,
  leg_frame_border,
  leg_horiz,
  leg_adj,
  leg_bg,
  leg_fg,
  leg_size,
  leg_border,
  leg_box_border,
  leg_box_cex,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}}

\item{var}{name(s) of the variable(s) to plot}

\item{type}{\itemize{
\item \strong{base}: base maps
\item \strong{prop}: proportional symbols maps
\item \strong{choro}: choropleth maps
\item \strong{typo}: typology maps
\item \strong{symb}: symbols maps
\item \strong{grad}: graduated symbols maps
\item \strong{prop_choro}: proportional symbols maps with symbols colors based
on a quantitative data classification
\item \strong{prop_typo}: proportional symbols maps with symbols colors based
on qualitative data
\item \strong{symb_choro}: symbols maps with symbols colors based on
a quantitative data classification
}}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks} and Details)}

\item{nbreaks}{number of classes}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{if \code{pal} is a \link{hcl.colors} palette name, the alpha-transparency level in the range [0,1]}

\item{rev}{if \code{pal} is a \link{hcl.colors} palette name, whether the ordering of the colors should be reversed (TRUE) or not (FALSE)}

\item{inches}{size of the biggest symbol (radius for circles, half width for squares) in inches.}

\item{val_max}{maximum value used for proportional symbols}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{col}{color}

\item{lwd_max}{line width of the largest line}

\item{val_order}{values order, a character vector that matches var modalities}

\item{pch}{point type}

\item{cex}{point size}

\item{border}{border color}

\item{lwd}{border width}

\item{col_na}{color for missing values}

\item{cex_na}{cex (point size) for NA values}

\item{pch_na}{pch (point type) for NA values}

\item{expandBB}{fractional values to expand the bounding box with, in each
direction (bottom, left, top, right)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos = NA then the legend is not plotted. If leg_pos = 'interactive' click onthe map to choose the legend position.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_frame_border}{border color of the legend frame}

\item{leg_horiz}{display the legend horizontally (for proportional symbols and choropleth types)}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_bg}{color of the legend backgournd}

\item{leg_fg}{color of the legend foreground}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{leg_border}{symbol border color(s)}

\item{leg_box_border}{border color of legend boxes}

\item{leg_box_cex}{width and height size expansion of boxes}

\item{...}{further parameters from \link{plot} for sfc objects}
}
\value{
x is (invisibly) returned.
}
\description{
This is the main function of the package.
\code{mf_map()} can be used to plot all types of maps.\cr
The three main arguments are: \code{x} (sf object), \code{var} (variable to map), and
\code{type} (map type).\cr
Relevant arguments and default values for each map types are detailed in
specific functions, see Details.
}
\details{
Relevant arguments, default values and examples for each map types are
detailed in specific functions:
\itemize{
\item \strong{base}: base maps - \link{mf_base}
\item \strong{prop}: proportional symbols maps - \link{mf_prop}
\item \strong{choro}: choropleth maps - \link{mf_choro}
\item \strong{typo}: typology maps - \link{mf_typo}
\item \strong{symb}: symbols maps - \link{mf_symb}
\item \strong{grad}: graduated symbols maps - \link{mf_grad}
\item \strong{prop_choro}: proportional symbols maps with symbols colors based
on a quantitative data classification - \link{mf_prop_choro}
\item \strong{prop_typo}: proportional symbols maps with symbols colors based
on qualitative data - \link{mf_prop_typo}
\item \strong{symb_choro}: symbols maps with symbols colors based on
a quantitative data classification - \link{mf_symb_choro}
}

Breaks defined by a numeric vector or a classification method are
left-closed: breaks defined by \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5[, [5 - 10[, [10 - 15[, [15 - 20].
The "jenks" method is an exception and has to be right-closed.
Jenks breaks computed as \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5], ]5 - 10], ]10 - 15], ]15 - 20].
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_map(mtq, var = "POP", type = "prop")
mf_map(mtq, var = "MED", type = "choro")
mf_map(mtq, var = "STATUS", type = "typo")
mf_map(mtq)
mf_map(mtq, var = "STATUS", type = "symb")
mf_map(mtq)
mf_map(mtq, var = "POP", type = "grad")
mf_map(mtq)
mf_map(mtq, var = c("POP", "MED"), type = "prop_choro")
mf_map(mtq)
mf_map(mtq, var = c("POP", "STATUS"), type = "prop_typo")
mf_map(mtq)
mf_map(mtq, var = c("STATUS", "MED"), type = "symb_choro")
}
