% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_prop.R
\name{mf_prop}
\alias{mf_prop}
\title{Plot proportional symbols}
\usage{
mf_prop(
  x,
  var,
  inches = 0.3,
  val_max,
  lwd_max = 20,
  symbol = "circle",
  col = "tomato4",
  border,
  lwd = 0.7,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 0,
  leg_frame = FALSE,
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{inches}{size of the biggest symbol (radius for circles, half width for squares) in inches.}

\item{val_max}{maximum value used for proportional symbols}

\item{lwd_max}{line width of the largest line}

\item{symbol}{type of symbols, 'circle' or 'square'}

\item{col}{color}

\item{border}{border color}

\item{lwd}{border width}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos is 'n' then the legend is not plotted.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot proportional symbols.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_prop(mtq, "POP")

mf_map(mtq)
mf_prop(
  x = mtq, var = "POP", inches = .4, symbol = "circle", val_max = 90000,
  col = "tomato1", border = "blue", lwd = 1,
  leg_pos = "right", leg_title = "Population",
  leg_title_cex = 1, leg_val_cex = .8, leg_val_rnd = 0,
  leg_frame = TRUE, add = TRUE
)
}
\keyword{internal}
