% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_map_s.R
\name{mf_symb}
\alias{mf_symb}
\title{Plot symbols}
\usage{
mf_symb(
  x,
  var,
  pal = "Dynamic",
  border,
  pch,
  cex = 1,
  lwd = 0.7,
  col_na = "grey",
  pch_na = 4,
  cex_na = 1,
  val_order,
  leg_pos = mf_get_leg_pos(x),
  leg_title = var,
  leg_title_cex = 0.8,
  leg_val_cex = 0.6,
  leg_val_rnd = 2,
  leg_no_data = "No data",
  leg_frame = FALSE,
  add
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{border}{border color}

\item{pch}{pch for symbols}

\item{cex}{cex for symbols}

\item{lwd}{border width}

\item{col_na}{color for missing values}

\item{pch_na}{pch for NA values}

\item{cex_na}{cex for NA values}

\item{val_order}{val order}

\item{leg_pos}{position of the legend, one of 'topleft', 'top','topright', 'right', 'bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). If leg_pos is 'n' then the legend is not plotted.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
No return value, a map is displayed.
}
\description{
Plot symbols based on qualitative data.
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_symb(mtq, "STATUS")

mtq[6, "STATUS"] <- NA
mf_map(mtq)
mf_symb(
  x = mtq, var = "STATUS", pch = c(21:23), pal = c("red1", "tan1", "khaki1"),
  border = "grey20", cex = c(1.5, 1, .9), lwd = .5,
  val_order = c("Prefecture", "Sub-prefecture", "Simple municipality"),
  pch_na = 24, leg_frame = TRUE
)
}
\keyword{internal}
