% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_mapmixture.R
\name{mapmixture}
\alias{mapmixture}
\title{Plot Pie Charts on Map}
\usage{
mapmixture(
  admixture_df,
  coords_df,
  cluster_cols = NULL,
  cluster_names = NULL,
  boundary = NULL,
  crs = 4326,
  basemap = NULL,
  pie_size = 1,
  pie_border = 0.2,
  pie_opacity = 1,
  land_colour = "#d9d9d9",
  sea_colour = "#deebf7",
  expand = FALSE,
  arrow = TRUE,
  arrow_size = 1,
  arrow_position = "tl",
  scalebar = TRUE,
  scalebar_size = 1,
  scalebar_position = "tl",
  plot_title = "",
  plot_title_size = 12,
  axis_title_size = 10,
  axis_text_size = 8
)
}
\arguments{
\item{admixture_df}{data.frame or tibble containing admixture data (see examples).}

\item{coords_df}{data.frame or tibble containing coordinates data (see examples).}

\item{cluster_cols}{character vector of colours the same length as the number of clusters.
If \code{NULL}, a blue-green palette is used.}

\item{cluster_names}{character vector of names the same length as the number of clusters.
If \code{NULL}, the cluster column names are used.}

\item{boundary}{named numeric vector defining the map bounding. e.g. \code{c(xmin=-15, xmax=15, ymin=30, ymax=50)}.
If \code{NULL}, a default bounding box is calculated.}

\item{crs}{coordinate reference system. Default is the WGS 84 - World Geodetic System 1984 (EPSG:\code{4326}).
See \code{?sf::st_crs} for details.}

\item{basemap}{SpatRaster or sf object to use as the basemap. A SpatRaster object can be created from a file
using the \code{terra::rast()} function. A sf object can be created from a file
using the \code{sf::st_read()} function. If \code{NULL}, world country boundaries are used.}

\item{pie_size}{numeric value of zero or greater.}

\item{pie_border}{numeric value of zero or greater.}

\item{pie_opacity}{numeric value of zero to one.}

\item{land_colour}{string defining the colour of land.}

\item{sea_colour}{string defining the colour of sea.}

\item{expand}{expand axes (\code{TRUE} or \code{FALSE}).}

\item{arrow}{show arrow (\code{TRUE} or \code{FALSE}). Added using the \code{ggspatial::annotation_north_arrow()} function.}

\item{arrow_size}{numeric value of zero or greater.}

\item{arrow_position}{string defining the position of the arrow (\code{"tl"}, \code{"tr"}, \code{"bl"}, \code{"br"}).}

\item{scalebar}{show scalebar (\code{TRUE} or \code{FALSE}). Added using the \code{ggspatial::annotation_scale()} function.}

\item{scalebar_size}{numeric value of zero or greater.}

\item{scalebar_position}{string defining the position of the scalebar (\code{"tl"}, \code{"tr"}, \code{"bl"}, \code{"br"}).}

\item{plot_title}{string defining the main title of the plot.}

\item{plot_title_size}{numeric value of zero or greater.}

\item{axis_title_size}{numeric value of zero or greater.}

\item{axis_text_size}{numeric value of zero or greater.}
}
\value{
A ggplot object.
}
\description{
Plot admixture proportions as pie charts on a projected map.
In data sets where there are multiple individuals per site,
the function will calculate the mean average admixture proportion for each site.
}
\examples{
# Admixture Format 1
file <- system.file("extdata", "admixture1.csv", package = "mapmixture")
admixture1 <- read.csv(file)

# Admixture Format 2
file <- system.file("extdata", "admixture2.csv", package = "mapmixture")
admixture2 <- read.csv(file)

# Admixture Format 3
file <- system.file("extdata", "admixture3.csv", package = "mapmixture")
admixture3 <- read.csv(file)

# Coordinates Format
file <- system.file("extdata", "coordinates.csv", package = "mapmixture")
coordinates <- read.csv(file)

# Plot using default parameters
mapmixture(admixture1, coordinates)

\donttest{# Plot using the ETRS89-extended / LAEA Europe coordinate reference system
mapmixture(admixture1, coordinates, crs = 3035)}

\donttest{# Plot using custom parameters
mapmixture(
  admixture_df = admixture1,
  coords_df = coordinates,
  cluster_cols = c("#f1a340","#998ec3"),
  cluster_names = c("Group 1","Group 2"),
  crs = "+proj=merc +a=6378137 +b=6378137 +lat_ts=0 +lon_0=0 +x_0=0 +y_0=0 +units=m",
  boundary = c(xmin=-15, xmax=16, ymin=40, ymax=62),
  pie_size = 1.5,
  pie_border = 0.2,
  pie_opacity = 1,
  land_colour = "#d9d9d9",
  sea_colour = "#deebf7",
  expand = FALSE,
  arrow = TRUE,
  arrow_size = 1,
  arrow_position = "tl",
  scalebar = TRUE,
  scalebar_size = 1,
  scalebar_position = "tl",
  plot_title = "Mapmixture Figure",
  plot_title_size = 15,
  axis_title_size = 12,
  axis_text_size = 10
)}
}
