% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mangroves_area.R
\docType{data}
\name{mangroves_area}
\alias{mangroves_area}
\title{Calculate mangrove extent based on Global Mangrove Watch (GMW)}
\format{
A tibble with a column for area of mangrove (in ha) and corresponding year.
}
\description{
This function allows to efficiently calculate area of mangrove from
Global Mangrove Watch - World Conservation Monitoring Centre (WCMC)
for polygons. For each polygon, the area of the mangrove (in hectare)
for desired year is returned.
The required resources for this indicator are:
\itemize{
\item \link{gmw}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
                        package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = c(1996, 2016),
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("gmw") \%>\%
  calc_indicators("mangroves_area") \%>\%
  tidyr::unnest(mangroves_area)))
}
\keyword{indicator}
