% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_biome.R
\docType{data}
\name{biome}
\alias{biome}
\title{Calculate biomes statistics (TEOW) based on WWF}
\format{
A tibble with a column for name of the biomes and corresponding area (in ha).
}
\description{
This function allows to efficiently retrieve the name of the biomes
and compute the corresponding area from Terrestrial Ecoregions of the
World (TEOW) - World Wildlife Fund (WWF) for polygons. For each polygon,
the name and area of the biomes (in hectare) is returned.
The required resources for this indicator are:
\itemize{
\item \link{ecoregions}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg", package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2001,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("ecoregions") \%>\%
  calc_indicators("biome") \%>\%
  tidyr::unnest(biome))
}
\keyword{indicator}
