% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_can_box.R
\name{esp_get_can_box}
\alias{esp_get_can_box}
\alias{esp_get_can_provinces}
\title{Get \pkg{sf} lines and polygons for insetting the Canary Islands}
\source{
\code{esp_get_can_provinces} extracted from CartoBase ANE,
\code{se89_mult_admin_provcan_l.shp} file.
}
\usage{
esp_get_can_box(style = "right", moveCAN = TRUE, epsg = "4258")

esp_get_can_provinces(moveCAN = TRUE, epsg = "4258")
}
\arguments{
\item{style}{Style of line around Canary Islands. Four options available:
\code{"left"}, \code{"right"}, \code{"box"} or \code{"poly"}.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands}.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}
}
\value{
A \pkg{sf} polygon or line depending of \code{style} parameter.

\code{esp_get_can_provinces} returns a \code{LINESTRING} object.
}
\description{
When plotting Spain, it is usual to represent the Canary Islands as an inset
(see \code{moveCAN} on \code{\link[=esp_get_nuts]{esp_get_nuts()}}). These functions provides complementary
lines and polygons to be used when the Canary Islands are displayed
as an inset.
\itemize{
\item \code{\link[=esp_get_can_box]{esp_get_can_box()}} is used to draw lines around the displaced Canary
Islands.
}

\itemize{
\item \code{\link[=esp_get_can_provinces]{esp_get_can_provinces()}} is used to draw a separator line between the two
provinces of the Canary Islands.
}
}
\section{Displacing the Canary Islands}{
While \code{moveCAN} is useful for visualization, it would alter the actual
geographic position of the Canary Islands. When using the output for
spatial analysis or using tiles (e.g. with \code{\link[=esp_getTiles]{esp_getTiles()}} or
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}})  this option should be set to \code{FALSE} in order to
get the actual coordinates, instead of the modified ones.
}

\examples{

Provs <- esp_get_prov()
Box <- esp_get_can_box()
Line <- esp_get_can_provinces()

# Plot
library(ggplot2)

ggplot(Provs) +
  geom_sf() +
  geom_sf(data = Box) +
  geom_sf(data = Line) +
  theme_linedraw()
\donttest{
# Displacing Canary

# By same factor

displace <- c(15, 0)

Provs_D <- esp_get_prov(moveCAN = displace)

Box_D <- esp_get_can_box(style = "left", moveCAN = displace)

Line_D <- esp_get_can_provinces(moveCAN = displace)

ggplot(Provs_D) +
  geom_sf() +
  geom_sf(data = Box_D) +
  geom_sf(data = Line_D) +
  theme_linedraw()


# Example with poly option

# Get countries with giscoR

library(giscoR)

# Low resolution map
res <- "20"

Countries <-
  gisco_get_countries(
    res = res,
    epsg = "4326",
    country = c("France", "Portugal", "Andorra", "Morocco", "Argelia")
  )
CANbox <-
  esp_get_can_box(
    style = "poly",
    epsg = "4326",
    moveCAN = c(12.5, 0)
  )

CCAA <- esp_get_ccaa(
  res = res,
  epsg = "4326",
  moveCAN = c(12.5, 0) # Same displacement factor)
)

# Plot

ggplot(Countries) +
  geom_sf(fill = "#DFDFDF") +
  geom_sf(data = CANbox, fill = "#C7E7FB", linewidth = 1) +
  geom_sf(data = CCAA, fill = "#FDFBEA") +
  coord_sf(
    xlim = c(-10, 4.3),
    ylim = c(34.6, 44)
  ) +
  theme(
    panel.background = element_rect(fill = "#C7E7FB"),
    panel.grid = element_blank()
  )
}
}
\seealso{
Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_simpl_prov}()}
}
\concept{political}
