% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{close_centrality}
\alias{close_centrality}
\alias{node_closeness}
\alias{node_reach}
\alias{node_harmonic}
\alias{node_information}
\alias{tie_closeness}
\alias{net_closeness}
\alias{net_reach}
\alias{net_harmonic}
\title{Measures of closeness-like centrality and centralisation}
\usage{
node_closeness(.data, normalized = TRUE, direction = "out", cutoff = NULL)

node_reach(.data, normalized = TRUE, k = 2)

node_harmonic(.data, normalized = TRUE, k = -1)

node_information(.data, normalized = TRUE)

tie_closeness(.data, normalized = TRUE)

net_closeness(.data, normalized = TRUE, direction = c("all", "out", "in"))

net_reach(.data, normalized = TRUE, k = 2)

net_harmonic(.data, normalized = TRUE, k = 2)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}

\item{direction}{Character string, “out” bases the measure on outgoing ties,
“in” on incoming ties, and "all" on either/the sum of the two.
For two-mode networks, "all" uses as numerator the sum of differences
between the maximum centrality score for the mode
against all other centrality scores in the network,
whereas "in" uses as numerator the sum of differences
between the maximum centrality score for the mode
against only the centrality scores of the other nodes in that mode.}

\item{cutoff}{Maximum path length to use during calculations.}

\item{k}{Integer of steps out to calculate reach}
}
\description{
These functions calculate common closeness-related centrality measures for one- and two-mode networks:
\itemize{
\item \code{node_closeness()} measures the closeness centrality of nodes in a network.
\item \code{node_reach()} measures nodes' reach centrality,
or how many nodes they can reach within \emph{k} steps.
\item \code{node_harmonic()} measures nodes' harmonic centrality or valued centrality,
which is thought to behave better than reach centrality for disconnected networks.
\item \code{node_information()} measures nodes' information centrality or
current-flow closeness centrality.
\item \code{tie_closeness()} measures the closeness of each tie to other ties in the network.
\item \code{net_closeness()} measures a network's closeness centralization.
\item \code{net_reach()} measures a network's reach centralization.
\item \code{net_harmonic()} measures a network's harmonic centralization.
}

All measures attempt to use as much information as they are offered,
including whether the networks are directed, weighted, or multimodal.
If this would produce unintended results,
first transform the salient properties using e.g. \code{\link[=to_undirected]{to_undirected()}} functions.
All centrality and centralization measures return normalized measures by default,
including for two-mode networks.
}
\examples{
node_closeness(ison_southern_women)
node_reach(ison_adolescents)
(ec <- tie_closeness(ison_adolescents))
plot(ec)
ison_adolescents \%>\% mutate_ties(weight = ec) \%>\% 
   graphr()
net_closeness(ison_southern_women, direction = "in")
}
\references{
Marchiori, M, and V Latora. 2000.
"Harmony in the small-world".
\emph{Physica A} 285: 539-546.

Dekker, Anthony. 2005.
"Conceptual distance in social network analysis".
\emph{Journal of Social Structure} 6(3).
}
\seealso{
Other centrality: 
\code{\link{between_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}}

Other measures: 
\code{\link{between_centrality}},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{measure_attributes}},
\code{\link{measure_closure}},
\code{\link{measure_cohesion}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_infection}},
\code{\link{measure_net_diffusion}},
\code{\link{measure_node_diffusion}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{centrality}
\concept{measures}
