% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_autograph.R
\name{grapht}
\alias{grapht}
\title{Easily animate dynamic networks with sensible defaults}
\source{
https://blog.schochastics.net/posts/2021-09-15_animating-network-evolutions-with-gganimate/
}
\usage{
grapht(
  tlist,
  layout,
  labels = TRUE,
  node_color,
  node_shape,
  node_size,
  edge_color,
  edge_size,
  keep_isolates = TRUE,
  ...
)
}
\arguments{
\item{tlist}{The same migraph-compatible network listed according to
a time attribute, waves, or slices.}

\item{layout}{An igraph, ggraph, or manynet layout algorithm.
If not declared, defaults to "triad" for networks with 3 nodes,
"quad" for networks with 4 nodes,
"stress" for all other one mode networks,
or "hierarchy" for two mode networks.
For "hierarchy" layout, one can further split graph by
declaring the "center" argument as the "events", "actors",
or by declaring a node name.
For "concentric" layout algorithm please declare the "membership" as an
extra argument.
The "membership" argument expects either a quoted node attribute present
in data or vector with the same length as nodes to draw concentric circles.
For "multilevel" layout algorithm please declare the "level"
as extra argument.
The "level" argument expects either a quoted node attribute present
in data or vector with the same length as nodes to hierarchically
order categories.
If "level" is missing, function will look for 'lvl' node attribute in data.
The "lineage" layout ranks nodes in Y axis according to values.
For "lineage" layout algorithm please declare the "rank"
as extra argument.
The "rank" argument expects either a quoted node attribute present
in data or vector with the same length as nodes.}

\item{labels}{Logical, whether to print node names
as labels if present.}

\item{node_color}{Node variable to be used for coloring the nodes.
It is easiest if this is added as a node attribute to
the graph before plotting.
Nodes can also be colored by declaring a color instead.}

\item{node_shape}{Node variable to be used for shaping the nodes.
It is easiest if this is added as a node attribute to
the graph before plotting.
Nodes can also be shaped by declaring a shape instead.}

\item{node_size}{Node variable to be used for sizing the nodes.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all node-related statistics prior
to using this function.
Nodes can also be sized by declaring a numeric size or vector instead.}

\item{edge_color}{Tie variable to be used for coloring the nodes.
It is easiest if this is added as an edge or tie attribute
to the graph before plotting.
Edges can also be colored by declaring a color instead.}

\item{edge_size}{Tie variable to be used for sizing the edges.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all edge-related statistics prior
to using this function.
Edges can also be sized by declaring a numeric size or vector instead.}

\item{keep_isolates}{Logical, whether to keep isolate nodes in the graph.
TRUE by default.
If FALSE, removes nodes from each frame they are isolated in.}

\item{...}{Extra arguments to pass on to the layout algorithm, if necessary.}
}
\value{
Shows a .gif image. Assigning the result of the function
saves the gif to a temporary folder and the object holds the path to this file.
}
\description{
This function provides users with an easy way to graph
dynamic network data for exploration and presentation.

It builds upon this package's \code{graphr()} function,
and inherits all the same features and arguments.
See \code{graphr()} for more.
However, it uses the \code{{gganimate}} package to animate the changes
between successive iterations of a network.
This is useful for networks in which the ties and/or the node or tie
attributes are changing.

A progress bar is shown if it takes some time to encoding all the
.png files into a .gif.
}
\examples{
#ison_adolescents \%>\%
#  mutate_ties(year = sample(1995:1998, 10, replace = TRUE)) \%>\%
#  to_waves(attribute = "year", cumulative = TRUE) \%>\%
#  grapht()
#ison_adolescents \%>\% 
#  mutate(gender = rep(c("male", "female"), times = 4),
#         hair = rep(c("black", "brown"), times = 4),
#         age = sample(11:16, 8, replace = TRUE)) \%>\%
#  mutate_ties(year = sample(1995:1998, 10, replace = TRUE),
#              links = sample(c("friends", "not_friends"), 10, replace = TRUE),
#              weekly_meetings = sample(c(3, 5, 7), 10, replace = TRUE)) \%>\%
#  to_waves(attribute = "year") \%>\%
#  grapht(layout = "concentric", membership = "gender",
#             node_shape = "gender", node_color = "hair",
#             node_size =  "age", edge_color = "links",
#             edge_size = "weekly_meetings")
#grapht(play_diffusion(ison_adolescents, seeds = 5))
}
\seealso{
Other mapping: 
\code{\link{configuration_layouts}},
\code{\link{graphr}()},
\code{\link{graphs}()},
\code{\link{partition_layouts}}
}
\concept{mapping}
