% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_autographr.R
\name{autographs}
\alias{autographs}
\alias{graphs}
\title{Easily graph a set of networks with sensible defaults}
\usage{
autographs(netlist, waves, based_on = c("first", "last", "both"), ...)

graphs(netlist, waves, based_on = c("first", "last", "both"), ...)
}
\arguments{
\item{netlist}{A list of manynet-compatible networks.}

\item{waves}{Numeric, the number of plots to be displayed side-by-side.
If missing, the number of plots will be reduced to the first and last
when there are more than four plots.
This argument can also be passed a vector selecting the waves to plot.}

\item{based_on}{Whether the layout of the joint plots should
be based on the "first" or the "last" network, or "both".}

\item{...}{Additional arguments passed to \code{autographr()}.}
}
\value{
Multiple \code{ggplot2::ggplot()} objects displayed side-by-side.
}
\description{
This function provides users with an easy way to graph
lists of network data for comparison.

It builds upon this package's \code{autographr()} function,
and inherits all the same features and arguments.
See \code{autographr()} for more.
However, it uses the \code{{patchwork}} package to plot the graphs
side by side and, if necessary, in successive rows.
This is useful for lists of networks that represent, for example,
ego or component subgraphs of a network,
or a list of a network's different types of tie or across time.
By default just the first and last network will be plotted,
but this can be overridden by the "waves" parameter.

Where the graphs are of the same network (same nodes),
the graphs may share a layout to facilitate comparison.
By default, successive graphs will use the layout calculated for
the "first" network, but other options include the "last" layout,
or a mix, "both", of them.
}
\examples{
#autographs(to_egos(ison_adolescents))
#autographs(to_egos(ison_adolescents), waves = 8)
#autographs(to_egos(ison_adolescents), waves = c(2, 4, 6))
#autographs(play_diffusion(ison_adolescents))
}
\seealso{
Other mapping: 
\code{\link{attributes}()},
\code{\link{autographr}()},
\code{\link{autographt}()},
\code{\link{configuration_layouts}},
\code{\link{partition_layouts}},
\code{\link{properties}}
}
\concept{mapping}
