% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_attributes.R
\name{attributes}
\alias{attributes}
\alias{node_names}
\alias{node_mode}
\alias{node_attribute}
\alias{tie_attribute}
\alias{tie_weights}
\alias{tie_signs}
\title{Describing attributes of nodes or ties in a network}
\usage{
node_names(.data)

node_mode(.data)

node_attribute(.data, attribute)

tie_attribute(.data, attribute)

tie_weights(.data)

tie_signs(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{attribute}{Character string naming an attribute in the object.}
}
\value{
\verb{node_*()} and \verb{tie_*()} always return vectors the same length
as the number of nodes or ties in the network, respectively.
}
\description{
These functions extract certain attributes from given network data.
They are also useful as helpers within other functions.
}
\section{Functions}{
\itemize{
\item \code{node_names()}: Extracts the names of the nodes in a network.

\item \code{node_mode()}: Extracts the mode of the nodes in a network.

\item \code{node_attribute()}: Extracts an attribute's values for the nodes in a network.

\item \code{tie_attribute()}: Extracts an attribute's values for the edges in a network.

\item \code{tie_weights()}: Extracts the weights of the edges in a network.

\item \code{tie_signs()}: Extracts the signs of the edges in a network.

}}
\examples{
node_names(ison_southern_women)
node_mode(ison_southern_women)
node_attribute(ison_lotr, "Race")
tie_attribute(ison_algebra, "task_tie")
tie_weights(to_mode1(ison_southern_women))
tie_signs(ison_marvel_relationships)
}
\seealso{
Other mapping: 
\code{\link{autographing}},
\code{\link{configuration_layouts}},
\code{\link{is}()},
\code{\link{partition_layouts}},
\code{\link{properties}}
}
\concept{mapping}
