% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_indirect_effects_math.R
\name{math_indirect}
\alias{math_indirect}
\alias{+.indirect}
\alias{-.indirect}
\title{Math Operators for
'indirect'-Class Objects}
\usage{
\method{+}{indirect}(e1, e2)

\method{-}{indirect}(e1, e2)
}
\arguments{
\item{e1}{An 'indirect'-class object.}

\item{e2}{An 'indirect'-class object.}
}
\value{
An 'indirect'-class object
with a list of effects stored. See
\code{\link[=indirect_effect]{indirect_effect()}} on details for
this class.
}
\description{
Mathematic operators for
'indirect'-class object, the output
of \code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}.
}
\details{
For now, only \code{+} operator
and \code{-} operator are supported. These
operators can be used to estimate and
test a function of effects between
the same pair of variables.

For example, they can be used to
compute and test the total effects
along different paths. They can also
be used to compute and test the
difference between the effects along
two paths.

The operators will check whether an
operation is valid. An operation is
not valid if
\enumerate{
\item the two paths do not start from
the same variable,
\item the two paths do not end at the
same variable,
\item moderators are involved but they
are not set to the same values in
both objects, and
\item bootstrap estimates stored in
\code{boot_out}, if any, are not identical.
\item Monte Carlo simulated
estimates stored in
\code{mc_out}, if any, are not identical.
}
\subsection{Multigroup Models}{

Since Version 0.1.14.2, support for
multigroup models has been added for models
fitted by \code{lavaan}. Both bootstrapping
and Monte Carlo confidence intervals
are supported. These operators can
be used to compute and test the
difference of an indirect effect
between two groups. This can also
be used to compute and test the
difference between a function of
effects between groups, for example,
the total indirect effects between
two groups.

The operators are flexible and allow
users to do many possible computations.
Therefore, users need to make sure
that the function of effects is
meaningful.
}
}
\examples{
library(lavaan)
dat <- modmed_x1m3w4y1
mod <-
"
m1 ~ a1 * x  + d1 * w1 + e1 * x:w1
m2 ~ m1 + a2 * x
y  ~ b1 * m1 + b2 * m2 + cp * x
"
fit <- sem(mod, dat,
           meanstructure = TRUE, fixed.x = FALSE,
           se = "none", baseline = FALSE)
est <- parameterEstimates(fit)
hi_w1 <- mean(dat$w1) + sd(dat$w1)

# Examples for cond_indirect():

# Conditional effect from x to m1 when w1 is 1 SD above mean
out1 <- cond_indirect(x = "x", y = "y", m = c("m1", "m2"),
              wvalues = c(w1 = hi_w1), fit = fit)
out2 <- cond_indirect(x = "x", y = "y", m = c("m2"),
              wvalues = c(w1 = hi_w1), fit = fit)
out3 <- cond_indirect(x = "x", y = "y",
              wvalues = c(w1 = hi_w1), fit = fit)

out12 <- out1 + out2
out12
out123 <- out1 + out2 + out3
out123
coef(out1) + coef(out2) + coef(out3)

# Multigroup model with indirect effects

dat <- data_med_mg
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, meanstructure = TRUE, fixed.x = FALSE, se = "none", baseline = FALSE,
           group = "group")

# If a model has more than one group,
# the argument 'group' must be set.
ind1 <- indirect_effect(x = "x",
                        y = "y",
                        m = "m",
                        fit = fit,
                        group = "Group A")
ind1
ind2 <- indirect_effect(x = "x",
                        y = "y",
                        m = "m",
                        fit = fit,
                        group = 2)
ind2

# Compute the difference in indirect effects between groups
ind2 - ind1

}
\seealso{
\code{\link[=indirect_effect]{indirect_effect()}} and
\code{\link[=cond_indirect]{cond_indirect()}}
}
