% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_dimensions}
\alias{compare_dimensions}
\title{Compare dimensions for 'many' data}
\usage{
compare_dimensions(datacube, dataset = "all")
}
\arguments{
\item{datacube}{A datacube from one of the many packages.}

\item{dataset}{A dataset in a datacube from one of the many packages.
By default, "all".
That is, all datasets in the datacube are used.
To select two or more datasets, please declare them as a vector.}
}
\value{
\code{compare_dimensions()} returns a tibble with information about each dataset
including the number of observations, the number of variables,
the earliest date, and the latest date in all observations.
}
\description{
Compare dimensions for 'many' data
}
\details{
\code{compare_dimensions()} compares the number of observations,
variables, the earliest date, and the latest date in all observations
for datasets in a 'many' datacube.
}
\examples{
\donttest{
compare_dimensions(emperors)
}
}
\seealso{
Other compare_: 
\code{\link{compare_categories}()},
\code{\link{compare_missing}()},
\code{\link{compare_overlap}()},
\code{\link{compare_ranges}()}
}
\concept{compare_}
