% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_io_functions.R
\name{save_analysis_summary}
\alias{save_analysis_summary}
\title{Save Analysis Summary}
\usage{
save_analysis_summary(results, file_path = NULL, format = "rds")
}
\arguments{
\item{results}{List. Complete analysis results from workflow functions}

\item{file_path}{Character. Output file path. If NULL, auto-generated}

\item{format}{Character. Output format: "rds", "json", or "txt"}
}
\value{
Character. Path to saved file
}
\description{
Save comprehensive summary of analysis parameters and results
}
\examples{
\donttest{
# Create analysis results first
results <- run_builtin_analysis(scale = "county", year = 2016)

# Save complete analysis summary
summary_path <- file.path(tempdir(), "analysis_summary_2016.json")
save_analysis_summary(results, summary_path, format = "json")
}
}
