% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agricultural_functions.R
\name{agri_classify_phosphorus_custom}
\alias{agri_classify_phosphorus_custom}
\title{Classify Agricultural Phosphorus Status with Custom Efficiency Factor}
\usage{
agri_classify_phosphorus_custom(
  data,
  cropland_threshold,
  scale = "huc8",
  p_efficiency = 1
)
}
\arguments{
\item{data}{Data frame with processed agricultural data}

\item{cropland_threshold}{Numeric. Threshold for excluding small cropland areas}

\item{scale}{Character. Spatial scale for within-unit classification}

\item{p_efficiency}{Numeric. Phosphorus efficiency factor (default: 1.0, range: 0-1)}
}
\value{
Data frame with phosphorus classification added
}
\description{
Classify spatial units based on phosphorus balance with user-specified efficiency factor.
While standard phosphorus classification uses 100\\% efficiency (factor = 1.0), this function
allows sensitivity analysis by varying the phosphorus efficiency assumption for different
management scenarios or application methods.
}
\examples{
\donttest{
# Load and process data first
nugis_data <- load_builtin_nugis("county", 2016)
processed_data <- agri_process_nugis(nugis_data, "county")
cropland_threshold <- 500 * 2.47105  # 500 ha in acres

# Standard analysis with default 1.0 efficiency (100\%)
results_default <- agri_classify_phosphorus_custom(
  processed_data, cropland_threshold = cropland_threshold, p_efficiency = 1.0
)

# Analysis with reduced efficiency (e.g., accounting for losses)
results_reduced <- agri_classify_phosphorus_custom(
  processed_data, cropland_threshold = cropland_threshold, p_efficiency = 0.8
)

# Conservative analysis with lower efficiency
results_conservative <- agri_classify_phosphorus_custom(
  processed_data, cropland_threshold = cropland_threshold, p_efficiency = 0.6
)

# Compare classification changes across efficiency scenarios
table(results_default$P_class)
table(results_reduced$P_class)
table(results_conservative$P_class)
}
}
