% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wwtp_functions.R
\name{wwtp_clean_data}
\alias{wwtp_clean_data}
\title{Clean WWTP Data}
\usage{
wwtp_clean_data(wwtp_data, nutrient)

wwtp_clean_data(wwtp_data, nutrient)
}
\arguments{
\item{wwtp_data}{Data frame. Raw or standardized WWTP data}

\item{nutrient}{Character. "nitrogen" or "phosphorus"}
}
\value{
Data frame with cleaned WWTP data

Data frame with cleaned WWTP data
}
\description{
Clean and validate WWTP data for analysis

Clean and validate WWTP data for analysis
}
\examples{
\dontrun{
# Clean user-loaded data will not run. They need to be supplied by users
clean_data <- wwtp_clean_data(raw_wwtp_data, "nitrogen")

# Clean OSF data (usually already clean, available 2007-2016)
osf_data <- load_builtin_wwtp("phosphorus", 2012)
clean_data <- wwtp_clean_data(osf_data, "phosphorus")
}
\donttest{
# Load and clean WWTP data
raw_wwtp_data <- load_builtin_wwtp("nitrogen", 2016)
clean_data <- wwtp_clean_data(raw_wwtp_data, "nitrogen")
}
}
