% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_analysis_functions.R
\name{quick_state_analysis}
\alias{quick_state_analysis}
\title{Quick State Analysis with Visualization}
\usage{
quick_state_analysis(
  state,
  scale = "huc8",
  year = 2016,
  nutrients = c("nitrogen", "phosphorus"),
  include_wwtp = TRUE,
  output_dir = file.path(tempdir(), paste0("state_", tolower(state), "_results")),
  create_maps = TRUE,
  create_networks = TRUE,
  create_comparisons = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{state}{Character. Two-letter state abbreviation}

\item{scale}{Character. Spatial scale}

\item{year}{Numeric. Year to analyze}

\item{nutrients}{Character vector. Nutrients to analyze}

\item{include_wwtp}{Logical. Include WWTP analysis}

\item{output_dir}{Character. Output directory}

\item{create_maps}{Logical. Create maps}

\item{create_networks}{Logical. Create network plots}

\item{create_comparisons}{Logical. Create comparison plots}

\item{verbose}{Logical. Show progress}

\item{...}{Additional arguments}
}
\value{
List with results and visualizations
}
\description{
Run state-level analysis with automatic visualizations
}
\examples{
\donttest{
# Quick state analysis - use states with good data coverage
results <- quick_state_analysis(
  state = "TX",  # Texas has good data coverage
  scale = "county",
  year = 2016,
  nutrients = "nitrogen",
  include_wwtp = TRUE
)
}
}
