% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{outputspec_static_heatmap}
\alias{outputspec_static_heatmap}
\title{Specify output options for a static report containing heatmaps}
\usage{
outputspec_static_heatmap(
  fill_colour = "blue",
  y_label = NULL,
  item_order = NULL
)
}
\arguments{
\item{fill_colour}{colour to use for the tiles. Passed to \code{high} parameter of
\code{ggplot2::scale_fill_gradient()}}

\item{y_label}{string for y-axis label. Optional. If \code{NULL}, the label will
be constructed from the \code{inputspec()}}

\item{item_order}{named list corresponding to \code{item_cols} columns for
ordering the items in the output. List values are either \code{TRUE} for
ascending order, or a character vector of values contained in the named
column for explicit ordering. If \code{item_order = NULL}, the original order
will be kept. See Details.}
}
\value{
An \code{outputspec()} object
}
\description{
Each tab contains a heatmap with one row per time series.
}
\section{Details}{
 For \code{item_order}, the names of the list members should
correspond to the column names in the \code{df}. Any names that don't match will
be ignored. When multiple columns are specified, they are sorted together,
in the same priority order as the list. If a list item is \code{TRUE} then that
column is sorted in ascending order. If a list item is a character vector
then that column is sorted in the order of the vector first, with any
remaining values included alphabetically at the end. If you want to order
the tabs, it is recommended to put the \code{tab_col} as the first item in the
list.
}

\examples{
# Customise the plot
outspec <- outputspec_static_heatmap(
  fill_colour = "#56B1F7",
  y_label = "Daily records"
)

# Sort alphabetically by Antibiotic
outspec <- outputspec_static_heatmap(
  item_order = list("Antibiotic" = TRUE)
)

# Sort alphabetically by Location first,
# then put "Vancomycin" and "Linezolid" before other antibiotics
outspec <- outputspec_static_heatmap(
  item_order = list("Location" = TRUE,
                    "Antibiotic" = c("Vancomycin", "Linezolid"))
)
}
\seealso{
\code{\link[=outputspec_interactive]{outputspec_interactive()}}, \code{\link[=outputspec_static_multipanel]{outputspec_static_multipanel()}}
}
