% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{mwGroup}
\alias{mwGroup}
\title{Group inputs in a collapsible box}
\usage{
mwGroup(..., .display = TRUE)
}
\arguments{
\item{...}{inputs that will be grouped in the box}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the group should be shown/hidden.}
}
\value{
List of inputs
}
\description{
This function generates a collapsible box containing inputs. It can be useful
when there are a lot of inputs and one wants to group them.
}
\examples{
if(require(dygraphs)) {
  mydata <- data.frame(x = 1:100, y = rnorm(100))
  manipulateWidget(
    dygraph(mydata[range[1]:range[2], ],
            main = title, xlab = xlab, ylab = ylab),
    range = mwSlider(1, 100, c(1, 100)),
    "Graphical parameters" = mwGroup(
      title = mwText("Fictive time series"),
      xlab = mwText("X axis label"),
      ylab = mwText("Y axis label")
    )
  )
}

}
\seealso{
Other controls: \code{\link{mwCheckboxGroup}},
  \code{\link{mwCheckbox}}, \code{\link{mwDateRange}},
  \code{\link{mwDate}}, \code{\link{mwNumeric}},
  \code{\link{mwPassword}}, \code{\link{mwRadio}},
  \code{\link{mwSelect}}, \code{\link{mwSlider}},
  \code{\link{mwText}}
}
