% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{x_iris}
\alias{x_iris}
\title{Iris predictors data for Species classification}
\format{
A list of two named matrices, 'train' and 'test', respresenting the training and test sets for the predictors. These have 4 
columns each, with 120 and 30 rows respectively.
 \describe{
    \item{\code{Sepal.Length}}{Sepal length}
    \item{\code{Sepal.Width}}{Sepal width}
    \item{\code{Petal.Length}}{Petal length}
    \item{\code{Petal.Width}}{Petal width}
 }
}
\source{
Fisher, R. A. (1936) The use of multiple measurements in taxonomic problems. Annals of Eugenics, 7, Part II, 179-188. 
 The data were collected by Anderson, Edgar (1935). The irises of the Gaspe Peninsula, Bulletin of the American Iris Society, 59, 2-5
 \itemize{\item{\url{https://stat.ethz.ch/R-manual/R-devel/library/datasets/html/iris.html}}}
}
\usage{
x_iris
}
\description{
This data was taken from Edgar Anderson's famous iris data set. This gives the measurements (in centimeters)
of the variables sepal length and width and petal length and width, respectively, for 50 flowers from each of 3 species of iris. 
The species are Iris setosa, versicolor, and virginica. However, the species is seen as the target variable, and as such
has been removed from this dataset, whilst being added to the counterpart \code{y_iris} dataset. Furthermore, the 4 remaining 
'predictor' variables have been seperated into a training and test set with a ratio of 4:1, followed by centering and scaling.
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole.
}
\keyword{datasets}
