# WARNING - Generated by {fusen} from dev/import-data.Rmd: do not edit by hand

# test_that("my_median works properly and show error if needed", {
#   expect_true(my_median(1:12) == 6.5)
#   expect_error(my_median("text"))
# })
# Test with a correct and empty datasets in "inst/"
biotyper <- system.file("biotyper.csv", package = "maldipickr")
biotyper_empty <- system.file("biotyper_empty.csv", package = "maldipickr")

# Apply test on my function
test_that("read_biotyper_report works properly with correct dataset and best hits", {
  expect_equal(
    nrow(read_biotyper_report(biotyper)), 3
  )
  expect_equal(
    ncol(read_biotyper_report(biotyper)), 8
  )
  expect_equal(
    dplyr::pull(read_biotyper_report(biotyper), bruker_species),
    c("not reliable identification", "Escherichia coli", "Kosakonia cowanii")
  )
})
test_that("read_biotyper_report works properly with correct dataset and all hits in long format", {
  expect_equal(
    nrow(read_biotyper_report(biotyper, best_hits = FALSE, long_format = TRUE)), 30
  )
  expect_equal(
    ncol(read_biotyper_report(biotyper, best_hits = FALSE, long_format = TRUE)), 8
  )
})
test_that("read_biotyper_report works properly with correct dataset and all hits in wide format", {
  expect_equal(
    nrow(read_biotyper_report(biotyper, best_hits = FALSE, long_format = FALSE)), 3
  )
  expect_equal(
    ncol(read_biotyper_report(biotyper, best_hits = FALSE, long_format = FALSE)), 52
  )
})
test_that("read_biotyper_report with best_hits is the same whatever format", {
  expect_identical(
    read_biotyper_report(biotyper, best_hits = TRUE, long_format = TRUE),
    read_biotyper_report(biotyper, best_hits = TRUE, long_format = FALSE)
  )
})
test_that("read_biotyper_report is empty when no peaks are found", {
  expect_warning(
    out <- read_biotyper_report(biotyper_empty), "Remove"
  )
  expect_equal(
    nrow(out), 0
  )
})
