% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maic.R
\name{maicMatching}
\alias{maicMatching}
\title{calculate MAIC weights}
\usage{
maicMatching(
  index,
  target,
  dictionary,
  matching.variables,
  reporting.variables = NULL
)
}
\arguments{
\item{index}{A matrix or data.frame containing patient-level data}

\item{target}{A list containing target summary data}

\item{dictionary}{A data frame containing the columns "match.id",
"target.variable", "index.variable" and "match.type"}

\item{matching.variables}{A character vector indicating the match.id to use}

\item{reporting.variables}{A optional character vector of matches to report
upon (defaults to \code{matching.variables})}
}
\value{
An object of class \code{MaicAnalysis}, with components \code{weights}
        and \code{aggregate}, containing the weights vector and the covariate
        aggregate data respectively
}
\description{
From index patient level data and a set of target baseline characteristics,
calculate MAIC weights.
}
\details{
The \code{dictionary} is a data frame containing at least 4 vectors:
\itemize{
\item "match.id" - the name of the match, used to refer to it in the
             matching.variables list
\item "target.variable" - the name of the variable in the target values
                    list use to inform the matching. Use dependent on
                    type
\item "index.variable" - the name of the variable in the index data frame
                   to match on.
\item "match.type" - A string indicating the match type to use. The following
               values are accepted:
  \itemize{
  \item minimum - records with index values lower than the target variable will
            be discarded
  \item maximum - records with index values greater than the target variable will
            be discarded
  \item median - records with index values greater than the target variable will
           be assigned a value of 1, those lower 0. The target for matching
           will be a mean of 0.5
  \item quantile.X - Generalisation of the median code. records with index values
               greater than the target variable will be assigned a value of 
               1, those lower 0. The target for matching will be a mean of 
               0.X
  \item mean - records will match index value directly onto target value
  \item proportion - as mean, with index values encoded as 1 = true, 0 = false.
               If target proportion is exclusive (0 or 1 exactly) then
               excluded members of the index population shall receive no
               weighting.
  \item sd - a matching on the square of the index value on the sum of the
       square of the target mean and target standard deviation. The
       target mean is provided by the "supplementary.target.variable"
  \item var - a matching on the square of the index value on the sum of the
        square of the target mean and the variance specified by the target
        variable. The target mean is provided by the 
        "supplementary.target.variable"
  }
 }
 In addition, the following vector may be necessary:
 \itemize{
 \item "supplementary.target.variable" - The name of the variable in the target
                                   values list that provides e.g. the mean
                                   for sd and var matching.
 }
It is possible to use these match types to match on other variables, e.g.
variance, by pre-processing the input correctly.

Finally, the \code{matching.variables} is a list or character vector containing
\code{match.id}s to be acted upon in this MAIC.
}
\examples{
target <- c("Air.Flow" = 60,
            "Water.Temp" = 21,
            "Prop.Acid.Conc.LT.90" = 0.7,
            "min.air.flow" = 55)

stackloss$match.conc.lt.90 <- 
  ifelse(stackloss$Acid.Conc. < 90, 1, 0)

dict <- data.frame(
  "match.id" = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"),
  "target.variable" = 
    c("Air.Flow", "Water.Temp", 
      "Prop.Acid.Conc.LT.90", "min.air.flow"),
  "index.variable" = 
    c("Air.Flow", "Water.Temp", 
      "match.conc.lt.90", "Air.Flow"),
  "match.type" = 
    c("mean", "mean", "proportion", "min"), 
  stringsAsFactors = FALSE)

weightObj <- maicMatching(
  index = stackloss,
  target = target,
  dictionary = dict,
  matching.variables = 
    c("airflow", "watertemp", 
      "acidconc", "min.airflow"))
}
