% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphology.R
\name{morphology}
\alias{morphology}
\alias{image_morphology}
\alias{image_convolve}
\title{Morphology}
\usage{
image_morphology(image, method = "convolve", kernel = "Gaussian",
  iterations = 1, opts = list())

image_convolve(image, kernel = "Gaussian", iterations = 1,
  scaling = NULL, bias = NULL)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{method}{a string with a valid method from \code{\link[=morphology_types]{morphology_types()}}}

\item{kernel}{either a square matrix or a string. The string can either be a
parameterized \link[=kernel_types]{kerneltype} such as: \code{"DoG:0,0,2"} or \code{"Diamond"}
or it can contain a custom matrix (see examples)}

\item{iterations}{number of iterations}

\item{opts}{a named list or character vector with custom attributes}

\item{scaling}{string with kernel scaling. The special flag \code{"!"} automatically scales to full
dynamic range, for example: \code{"50\%!"}}

\item{bias}{output bias string, for example \code{"50\%"}}
}
\description{
Apply a morphology method. This is a very flexible function which
can be used to apply any morphology method with custom parameters.
See \href{http://www.imagemagick.org/Usage/morphology/}{imagemagick website}
for examples.
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{edges}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{fx}}, \code{\link{geometry}},
  \code{\link{ocr}}, \code{\link{options}},
  \code{\link{painting}}, \code{\link{segmentation}},
  \code{\link{transform}}, \code{\link{video}}
}
\concept{image}
