% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_artifacts.R
\name{get_artifacts}
\alias{get_artifacts}
\title{Get the artifacts (return values) of the pipelines in a MaestroSchedule object.}
\usage{
get_artifacts(schedule)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}
}
\value{
named list
}
\description{
Artifacts are return values from pipelines. They are accessible as a named list
where the names correspond to the names of the pipeline.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  schedule <- run_schedule(
    schedule,
    orch_frequency = "1 day",
    quiet = TRUE
  )

  get_artifacts(schedule)

  # Alternatively, use the underlying R6 method
  schedule$get_artifacts()
}
}
