% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolAggregate.R
\name{toolAggregate}
\alias{toolAggregate}
\title{toolAggregate}
\usage{
toolAggregate(x, rel, weight = NULL, from = NULL, to = NULL, dim = 1,
  partrel = FALSE)
}
\arguments{
\item{x}{magclass object that should be (dis-)aggregated}

\item{rel}{relation matrix, mapping or csv file containing a mapping.
A mapping object should contain 2 columns in which each element of x
is mapped to the category it should belong to after (dis-)aggregation}

\item{weight}{magclass object containing weights which should be considered
for a weighted aggregation. Please see the "details" section below for more
information}

\item{from}{Name of the first column to be used in rel if it is a
mapping (if not set the first or second column will be used).}

\item{to}{Name of the second column to be used in rel if it is a
mapping (if not set the second or third column will be used).}

\item{dim}{Specifying the dimension of the magclass object that should be
(dis-)aggregated. Either specified as an integer
(1=spatial,2=temporal,3=data) or if you want to specify a sub dimension
specified by name of that dimension or position within the given dimension
(e.g. 3.2 means the 2nd data dimension, 3.8 means the 8th data dimension).}

\item{partrel}{If set to TRUE allows that the relation matrix does contain
less entries than x and vice versa. These values without relation are lost
in the output.}
}
\value{
the aggregated data in magclass format
}
\description{
(Dis-)aggregates a magclass object from one resolution to another based on a
relation matrix or mapping
}
\details{
Basically toolAggregate is doing nothing more than a normal matrix
multiplication which is taking into account the 3 dimensional structure of
MAgPIE objects. So, you can provide any kind of relation matrix you would
like. However, for easier usability it is also possible to provide weights
for a weighted (dis-)aggregation as a MAgPIE object. In this case rel must
be a 1-0-matrix or a mapping between both resolutions. The weight
needs to be provided in the higher spatial aggregation, meaning for
aggregation the spatial resolution of your input data and in the case of
disaggregation the spatial resolution of your output data. The temporal and
data dimension must be either identical to the resolution of the data set
that should be (dis-)aggregated or 1. If the temporal and/or data dimension
is 1 this means that the same transformation matrix is applied for all years
and/or all data columns. In the case that a column should be just summed up
instead of being calculated as a weighted average you either do not provide
any weight (than all columns are just summed up) or your set this specific
weighting column to NA.
}
\examples{

# load example data
data(population_magpie)

# create example mapping
mapping <- data.frame(from=getRegions(population_magpie),to=rep(c("REG1","REG2"),5))
mapping 

# run aggregation
toolAggregate(population_magpie,mapping)
# weighted aggregation
toolAggregate(population_magpie,mapping, weight=population_magpie)
}
\seealso{
\code{\link{calcOutput}}
}
\author{
Jan Philipp Dietrich, Ulrich Kreidenweis
}
