% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-copula.r
\name{mable.hellcorr}
\alias{mable.hellcorr}
\alias{hellcorr}
\title{Estimate of Hellinger Correlation between two random variables and Bootstrap}
\usage{
mable.hellcorr(
  x,
  unif.mar = FALSE,
  pseudo.obs = c("empirical", "mable"),
  M0 = c(1, 1),
  M = c(30, 30),
  search = TRUE,
  mar.deg = TRUE,
  high.dim = FALSE,
  interval = cbind(0:1, 0:1),
  B = 200L,
  conf.level = 0.95,
  integral = TRUE,
  controls = mable.ctrl(sig.level = 0.05),
  progress = FALSE
)

hellcorr(
  x,
  unif.mar = FALSE,
  pseudo.obs = c("empirical", "mable"),
  M0 = c(1, 1),
  M = c(30, 30),
  search = TRUE,
  mar.deg = TRUE,
  high.dim = FALSE,
  interval = cbind(0:1, 0:1),
  B = 200L,
  conf.level = 0.95,
  integral = TRUE,
  controls = mable.ctrl(sig.level = 0.05),
  progress = FALSE
)
}
\arguments{
\item{x}{an \code{n x 2} data matrix of observations of the two random variables}

\item{unif.mar}{logical, whether all the marginals distributions are uniform or not. 
If not the pseudo observations will be created using \code{empirical} or \code{mable}  
marginal distributions.}

\item{pseudo.obs}{\code{"empirical"}: use empirical distribution to form pseudo, 
observations, or \code{"mable"}: use mable of marginal cdfs to form pseudo 
observations}

\item{M0}{a nonnegative integer or a vector of \code{d} nonnegative integers specify
starting candidate degrees for searching optimal degrees.}

\item{M}{a positive integer or a vector of \code{d} positive integers specify
the maximum candidate or the given model degrees for the joint density.}

\item{search}{logical, whether to search optimal degrees between \code{M0} and \code{M} 
or not but use \code{M} as the given model degrees for the joint density.}

\item{mar.deg}{logical, if TRUE (default), the optimal degrees are selected based on marginal data,
otherwise, the optimal degrees are chosen by the method of change-point. See details.}

\item{high.dim}{logical, data are high dimensional/large sample or not
if TRUE, run a slower version procedure which requires less memory}

\item{interval}{a 2 by 2 matrix, columns are the marginal supports}

\item{B}{the number of bootstrap samples and number of Monte Carlo runs for
estimating \code{p.value} of the test for Hellinger correlation = 0 
if \code{test=TRUE}.}

\item{conf.level}{confidence level}

\item{integral}{logical, using "integrate()" or not (Riemann sum)}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion \code{eps}. Default is \code{\link{mable.ctrl}}. See Details.}

\item{progress}{if TRUE a text progressbar is displayed}
}
\value{
\itemize{
  \item \code{eta} Hellinger correlation
  \item \code{CI.eta} Bootstrap confidence interval for 
         Hellinger correlation if \code{B}>0.
 }
}
\description{
Estimate of Hellinger Correlation between two random variables and Bootstrap
}
\details{
This function calls \code{mable.copula()} for estimation of the copula density.
}
\references{
Guan, Z.,  Nonparametric Maximum Likelihood Estimation of Copula
}
\seealso{
\code{\link{mable}}, \code{\link{mable.mvar}}, \code{\link{mable.copula}}
}
\author{
Zhong Guan <zguan@iu.edu>
}
\concept{copula density estimation}
\concept{multivariate Bernstein polynomial model for copula}
\keyword{copula}
\keyword{distribution}
\keyword{multivariate}
\keyword{nonparametric}
