% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ring.R
\name{ring}
\alias{ring}
\alias{ring.}
\alias{ring_}
\alias{ring_.}
\alias{m2_coefrings}
\alias{m2_termorders}
\alias{print.m2_polynomialring}
\title{Create a new ring in Macaulay2}
\usage{
ring(..., coefring = m2_coefrings(), order = m2_termorders(), code = FALSE)

ring.(..., coefring = m2_coefrings(), order = m2_termorders(), code = FALSE)

ring_(
  vars,
  coefring = m2_coefrings(),
  order = m2_termorders(),
  code = FALSE,
  ...
)

ring_.(
  vars,
  coefring = m2_coefrings(),
  order = m2_termorders(),
  code = FALSE,
  ...
)

m2_coefrings()

m2_termorders()

\method{print}{m2_polynomialring}(x, ...)
}
\arguments{
\item{...}{...}

\item{coefring}{coefficient ring (default: \code{"CC"})}

\item{order}{a term order (default: \code{"grevlex"})}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{vars}{vector of variable names}

\item{x}{formal argument for print method}
}
\value{
a reference to a Macaulay2 ring
}
\description{
Create a new ring in Macaulay2
}
\examples{

\dontrun{ requires Macaulay2

##### basic usage
########################################

ring("x", "y")
ring("x", "y", coefring = "QQ")


##### standard evaluation
########################################

ring_(c("x", "y"))
ring_(c("x", "y"), code = TRUE)

(myring <- ring_(c("x1","x2","x3","y"), coefring = "QQ", order = "lex"))

m2_name(myring)
m2_meta(myring, "vars")
m2_meta(myring, "coefring")
m2_meta(myring, "order")

##### other options
########################################

ring_.(c("x", "y"))
ring_.(c("x", "y"), code = TRUE)

}
}
