% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-lv.r, R/stat-lv.r
\docType{data}
\name{geom_lv}
\alias{GeomLv}
\alias{StatLv}
\alias{geom_lv}
\alias{scale_fill_lv}
\alias{stat_lv}
\title{Side-by-side LV boxplots with ggplot2.}
\format{An object of class \code{GeomLv} (inherits from \code{Geom}, \code{ggproto}) of length 6.}
\usage{
geom_lv(mapping = NULL, data = NULL, stat = "lv", position = "dodge",
  outlier.colour = "black", outlier.shape = 19, outlier.size = 1.5,
  outlier.stroke = 0.5, na.rm = TRUE, varwidth = FALSE,
  width.method = "linear", show.legend = NA, inherit.aes = TRUE, ...)

GeomLv

scale_fill_lv(...)

stat_lv(mapping = NULL, data = NULL, geom = "lv", position = "dodge",
  na.rm = TRUE, conf = 0.95, percent = NULL, k = NULL,
  show.legend = NA, inherit.aes = TRUE, ...)

StatLv
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{outlier.colour}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.shape}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.size}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{outlier.stroke}{Override aesthetics used for the outliers. Defaults
come from \code{geom_point()}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{varwidth}{if \code{FALSE} (default) draw boxes that are the same size for each group. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{width.method}{character, one of 'linear' (default), 'area', or 'height'. This parameter
determines whether the width of the box for letter value LV(i) should be proportional to i (linear), proportional to $2^{-i}$ (height), or  whether
the area of the box should be proportional to $2^{-i}$ (area).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom, stat}{Use to override the default connection between
\code{geom_lv} and \code{stat_lv}.}

\item{conf}{confidence level}

\item{percent}{numeric value: percent of data in outliers}

\item{k}{number of letter values shown}
}
\description{
An extension of standard boxplots which draws k letter statistics.
Conventional boxplots (Tukey 1977) are useful displays for conveying rough
information about the central 50\% of the data and the extent of the data.
For moderate-sized data sets (\eqn{n < 1000}), detailed estimates of tail
behavior beyond the quartiles may not be trustworthy, so the information
provided by boxplots is appropriately somewhat vague beyond the quartiles,
and the expected number of ``outliers'' and ``far-out'' values for a
Gaussian sample of size \eqn{n} is often less than 10 (Hoaglin, Iglewicz,
and Tukey 1986). Large data sets (\eqn{n \approx 10,000-100,000}) afford
more precise estimates of quantiles in the tails beyond the quartiles and
also can be expected to present a large number of ``outliers'' (about
\eqn{0.4 + 0.007 n}).
The letter-value box plot addresses both these shortcomings: it conveys
more detailed information in the tails using letter values, only out to the
depths where the letter values are reliable estimates of their
corresponding quantiles (corresponding to tail areas of roughly
\eqn{2^{-i}}); ``outliers'' are defined as a function of the most extreme
letter value shown. All aspects shown on the letter-value boxplot are
actual observations, thus remaining faithful to the principles that
governed Tukey's original boxplot.
}
\section{Computed/reported variables}{

\describe{
  \item{k}{Number of Letter Values used for the display}
  \item{LV}{Name of the Letter Value}
  \item{width}{width of the interquartile box}
}
}
\examples{
library(ggplot2)
p <- ggplot(mpg, aes(class, hwy))
p + geom_lv(aes(fill=..LV..)) + scale_fill_brewer()
p + geom_lv() + geom_jitter(width = 0.2)
p + geom_lv(alpha=1, aes(fill=..LV..)) + scale_fill_lv()

# Outliers
p + geom_lv(varwidth = TRUE, aes(fill=..LV..)) + scale_fill_lv()
p + geom_lv(fill = "grey80", colour = "black")
p + geom_lv(outlier.colour = "red", outlier.shape = 1)

# Plots are automatically dodged when any aesthetic is a factor
p + geom_lv(aes(fill = drv))

# varwidth adjusts the width of the boxes according to the number of observations
ggplot(ontime, aes(UniqueCarrier, TaxiIn + TaxiOut)) +
  geom_lv(aes(fill = ..LV..), varwidth=TRUE) +
  scale_fill_lv() +
  scale_y_sqrt() +
  theme_bw()

ontime$DayOfWeek <- as.POSIXlt(ontime$FlightDate)$wday
ggplot(ontime, aes(factor(DayOfWeek), TaxiIn + TaxiOut)) +
  geom_lv(aes(fill = ..LV..)) +
  scale_fill_lv() +
  scale_y_sqrt() +
  theme_bw()
}
\references{
McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
    box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link{stat_quantile}} to view quantiles conditioned on a
  continuous variable.
}
\keyword{datasets}

