% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{luz_metric_accuracy}
\alias{luz_metric_accuracy}
\title{Accuracy}
\usage{
luz_metric_accuracy()
}
\value{
Returns new Luz metric.
}
\description{
Computes accuracy for multi-class classification problems.
}
\details{
This metric expects to take logits or probabilities at every
update. It will then take the columnwise argmax and compare
to the target.
}
\examples{
if (torch::torch_is_installed()) {
library(torch)
metric <- luz_metric_accuracy()
metric <- metric$new()
metric$update(torch_randn(100, 10), torch::torch_randint(1, 10, size = 100))
metric$compute()
}
}
\seealso{
Other luz_metrics: 
\code{\link{luz_metric_binary_accuracy_with_logits}()},
\code{\link{luz_metric_binary_accuracy}()},
\code{\link{luz_metric_binary_auroc}()},
\code{\link{luz_metric_mae}()},
\code{\link{luz_metric_mse}()},
\code{\link{luz_metric_multiclass_auroc}()},
\code{\link{luz_metric_rmse}()},
\code{\link{luz_metric}()}
}
\concept{luz_metrics}
