% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Cross Validation}
\usage{
cv(x, y, intercept = TRUE, weights = NULL, grouping = NULL,
  groupWeights = NULL, parameterWeights = NULL, alpha = 1, lambda,
  d = 100, fold = 10L, cv.indices = list(), max.threads = NULL,
  use_parallel = FALSE, algorithm.config = lsgl.standard.config)
}
\arguments{
\item{x}{design matrix, matrix of size \eqn{N \times p}.}

\item{y}{response matrix, matrix of size \eqn{N \times K}.}

\item{intercept}{should the model include intercept parameters.}

\item{weights}{sample weights, vector of size \eqn{N \times K}.}

\item{grouping}{grouping of features, a factor or vector of length \eqn{p}. Each element of the factor/vector specifying the group of the feature.}

\item{groupWeights}{the group weights, a vector of length \eqn{m} (the number of groups).}

\item{parameterWeights}{a matrix of size \eqn{K \times p}.}

\item{alpha}{the \eqn{\alpha} value 0 for group lasso, 1 for lasso, between 0 and 1 gives a sparse group lasso penalty.}

\item{lambda}{lambda.min relative to lambda.max or the lambda sequence for the regularization path.}

\item{d}{length of lambda sequence (ignored if \code{length(lambda) > 1})}

\item{fold}{the fold of the cross validation, an integer larger than 1 and less than \eqn{N+1}. Ignored if \code{cv.indices != NULL}.}

\item{cv.indices}{a list of indices of a cross validation splitting.
If \code{cv.indices = NULL} then a random splitting will be generated using the \code{fold} argument.}

\item{max.threads}{Deprecated (will be removed in 2018),
instead use \code{use_parallel = TRUE} and registre parallel backend (see package 'doParallel').
The maximal number of threads to be used.}

\item{use_parallel}{If \code{TRUE} the \code{foreach} loop will use \code{\%dopar\%}. The user must registre the parallel backend.}

\item{algorithm.config}{the algorithm configuration to be used.}
}
\value{
\item{Yhat}{the cross validation estimated response matrix}
\item{Y.true}{the true response matrix, this is equal to the argument \code{y}}
\item{cv.indices}{the cross validation splitting used}
\item{features}{number of features used in the models}
\item{parameters}{number of parameters used in the models.}
}
\description{
Linear multiple output cross validation using multiple possessors
}
\examples{

set.seed(100) # This may be removed, it ensures consistency of the daily tests

## Simulate from Y=XB+E, the dimension of Y is N x K, X is N x p, B is p x K

N <- 50 #number of samples
p <- 25 #number of features
K <- 15  #number of groups

B<-matrix(sample(c(rep(1,p*K*0.1),rep(0, p*K-as.integer(p*K*0.1)))),nrow=p,ncol=K)
X1<-matrix(rnorm(N*p,1,1),nrow=N,ncol=p)
Y1 <-X1\%*\%B+matrix(rnorm(N*K,0,1),N,K)

## Do cross validation
fit.cv <- lsgl::cv(X1, Y1, alpha = 1, lambda = 0.1, intercept = FALSE)

## Cross validation errors (estimated expected generalization error)
Err(fit.cv)

## Do the same cross validation using 2 parallel units
cl <- makeCluster(2)
registerDoParallel(cl)

fit.cv <- lsgl::cv(X1, Y1, alpha = 1, lambda = 0.1, intercept = FALSE, use_parallel = TRUE)

stopCluster(cl)

Err(fit.cv)
}
\author{
Martin Vincent
}

