% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rorth.R
\name{rorth}
\alias{rorth}
\title{Generate A Random Orthonormal Matrix}
\usage{
rorth(nrow, ncol, sd = 1)
}
\arguments{
\item{nrow}{Integer giving the number of rows required.}

\item{ncol}{Integer giving the number of columns required.}

\item{sd}{The standard deviation passed to \code{\link{rnorm}}}
}
\description{
Uniformly sample an orthornormal matrix from the collection of all possible 
orthonormal matrices of a certain size. The QR decomposition is used on a 
matrix containing Gaussian random numbers. The QR decomposition might not
be the most efficient algorithm under some circumstances.
}
\examples{
set.seed(1)
rorth(5, 2)
}
\references{
Stewart, G. W. (1980). The efficient generation of random orthogonal matrices with an 
application to condition estimators. \emph{SIAM Journal on Numerical Analysis}, 17(3), 403-409.
}
