% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{evd_params}
\alias{evd_params}
\title{Function to return the EVD (Gumbel or GEV) parameters as a vector.}
\usage{
evd_params(
  x,
  evd_mod_str,
  nsloc = NULL,
  empty_evd_params,
  ntries = 3,
  silent = FALSE,
  returncs = TRUE
)
}
\arguments{
\item{x}{numeric vector of data to be fitted.}

\item{evd_mod_str}{either a string "fgumbel", "fgumbelx" or "fgev" from the extreme value distribution (evd) in the evd package}

\item{nsloc}{A data frame with the same number of rows as the length of x, for linear modelling of the location parameter. The data frame is treated as a covariate matrix (excluding the intercept). A numeric vector can be given as an alternative to a single column data frame.}

\item{empty_evd_params}{A preallocated vector or array used to store the return value when fitting fails}

\item{ntries}{number of tries to fit the evd}

\item{silent}{logical: should the report of error messages be suppressed?}

\item{returncs}{logical: should the centered and scaled values be returned}
}
\value{
a vector of estimate, var.cov, AIC, centered and scaled values
}
\description{
Function to return the EVD (Gumbel or GEV) parameters as a vector.
}
\examples{
# Ten records of 20 random data generated from the fgumbel EVD
am = lapply(1:10, function(x) evd::rgumbel(20))
tab = as.data.frame(t(sapply(am,function(x) evd_params(x,"fgumbel"))))
}
