% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{zoom}
\alias{zoom}
\title{Zoom Plot Region}
\usage{
zoom(layerId = NULL, scaleToFun = NULL)
}
\arguments{
\item{layerId}{numerical; which layer to scale the plot by.}

\item{scaleToFun}{scale to function. See details.}
}
\value{
a \code{ggproto} object
}
\description{
Change the visible plot region by scaling to different elements of the display.
}
\details{
Argument \code{layerId} is used for additional plot region settings.
If the \code{layerId} is set as \code{NULL} (default), the region of the
interactive graphics \code{loon} will be determined by the \code{ggplot} object
(i.e. \code{coord_cartesian}, \code{xlim}, etc);
else one can use \code{scaleToFun} to modify the region of the layer.

The \code{scaleToFun} is a function to scale the region.
If it is \code{NULL} (default), based on different layers, different scale functions
will be applied. For example, if the layer is the main graphic model, i.e. \code{l_plot}
\code{l_hist}, then the default \code{scaleToFun} is \code{\link{l_scaleto_plot}}; else
 if the layer is a general \code{l_layer} widget, the default \code{scaleToFun} would be
 \code{\link{l_scaleto_layer}} (see \code{\link{get_activeGeomLayers}}).

If it is not \code{NULL}, users can select one that precisely tailor their own
problems. The table shows the available \code{scaleToFun} functions
\tabular{ll}{\strong{scale to} \tab \strong{Subfunction}\cr
  plot \tab  \code{\link{l_scaleto_plot}}\cr
  world \tab \code{\link{l_scaleto_world}}\cr
  active \tab \code{\link{l_scaleto_active}}\cr
  selected \tab \code{\link{l_scaleto_selected}}\cr
  layer \tab \code{\link{l_scaleto_layer}}\cr}
Users can also supply their own function, providing its arguments match those
of the functions shown in the above table.
}
\examples{
if(interactive()) {
p <- l_ggplot(mtcars,
              mapping = aes(x = hp, y = mpg)) +
       geom_point(mapping = aes(color = factor(gear))) +
       geom_smooth(data = mtcars[mtcars$gear == 4, ],
                   method = "lm")
# a scatter plot with a fitted line on 4 gear cars
p
# scale to the second layer (smooth line)
p + zoom(layerId = 2)
# highlight the 3 gear cars
# scale to the selected points
p +
  selection(mtcars$gear == 3) +
  zoom(layerId = 1,
       scaleToFun = loon::l_scaleto_selected)
}
}
\seealso{
\code{\link{active}}, \code{\link{linking}}, \code{\link{selection}},
\code{\link{hover}}, \code{\link{interactivity}}
}
