% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{hperks}
\alias{hperks}
\alias{pperks}
\alias{dperks}
\alias{qperks}
\title{Hazard function of the Perks distribution}
\usage{
hperks(x, rate = 1, shape = 1, log = FALSE)

pperks(q, rate = 1, shape = 1, lower.tail = TRUE, log.p = FALSE)

dperks(x, rate = 1, shape = 1, log = FALSE)

qperks(p, rate = 1, shape = 1, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{rate}{rate parameter (\eqn{\nu})}

\item{shape}{shape parameter (\eqn{\alpha})}

\item{log}{logical; if \code{FALSE} (default), return the density, else the log likelihood of the individual observations.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}

\item{p}{vector of probabilities.}
}
\value{
a vector of (log)-hazard.

a vector of (log)-probabilities of the same length as \code{q}

a vector of (log)-density.

a vector of quantiles
}
\description{
Hazard function of the Perks distribution

Distribution function of the Perks distribution

Density function of the Perks distribution

Quantile function of the Perks distribution
}
\keyword{internal}
