% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xval.R
\name{lol.xval.split}
\alias{lol.xval.split}
\title{Cross-Validation Data Splitter}
\usage{
lol.xval.split(X, Y, k = "loo", ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{k}{the cross-validated method to perform. Defaults to \code{'loo'}.
\itemize{
\item{\code{'loo'}}{ Leave-one-out cross validation}
\item{\code{isinteger(k)}}{ perform \code{k}-fold cross-validation with \code{k} as the number of folds.}
}}

\item{...}{optional args.}
}
\value{
sets the cross-validation sets as a list, each element with an \code{X.train}, \code{X.test}, \code{Y.train}, and \code{Y.test}.
}
\description{
\code{sg.bern.xval_split_data} A function to split a dataset into
training and testing sets for cross validation.
}
\examples{
# prepare data for 10-fold validation
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
sets.xval.10fold <- lol.xval.split(X, Y, k=10)

# prepare data for loo validation
sets.xval.loo <- lol.xval.split(X, Y, k='loo')

}
\author{
Eric Bridgeford
}
