% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{partial.predict}
\alias{partial.predict}
\title{Partial prediction for boosted models}
\usage{
partial.predict(model, X, Z = NULL, n.iter = 1, ...)
}
\arguments{
\item{model}{Fitted \code{logic.boosted} model}

\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{n.iter}{Maximum number of boosting iterations for prediction}

\item{...}{Parameters supplied to \code{\link{predict.logicDT}}}
}
\value{
An array of dimension \code{(N, n.iter)} containing the partial
  predictions
}
\description{
Alternative prediction function for \code{logic.boosted} models
using up to \code{n.iter} boosting iterations.
An array of predictions for every number of boosting iterations
up to \code{n.iter} is returned.
}
\details{
The main purpose of this function is to retrieve the optimal number of
boosting iterations (early stopping) using a validation data set and to
restrict future predictions on this number of iterations.
}
