% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appenders.R
\name{http_appender}
\alias{http_appender}
\title{Log Messages via HTTP}
\usage{
http_appender(url, method = "POST", layout = default_log_layout(), ...)
}
\arguments{
\item{url}{The URL to submit messages to.}

\item{method}{The HTTP method to use, usually \code{"POST"} or \code{"GET"}.}

\item{layout}{A layout function taking a \code{level} parameter and
additional arguments corresponding to the message.}

\item{...}{Further arguments passed on to \code{\link[httr]{POST}}.}
}
\description{
Send messages in the body of HTTP requests. Responses with status code 400
or above will trigger errors.

Requires the \code{httr} package.
}
\examples{
\dontrun{
# POST messages to localhost.
appender <- http_appender("localhost")
appender("INFO", "Message.")

# POST JSON-encoded messages.
appender <- http_appender(
  "localhost", method = "POST", layout = default_log_layout(),
  httr::content_type_json()
)
appender("INFO", "Message.")
}

}
\seealso{
\code{\link{appenders}} for more information on Appenders.
}
