% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/png.R
\name{writePng}
\alias{writePng}
\title{Write a PNG file}
\usage{
writePng(image, file, ..., compression = 4L, interlace = FALSE)
}
\arguments{
\item{image}{An array containing the pixel data.}

\item{file}{A character string giving the file name to write to.}

\item{...}{Additional metadata elements, which override equivalently named
attributes of \code{image}. See Details.}

\item{compression}{Compression level, an integer value between 0 (no
compression, fastest) and 6 (maximum compression, slowest).}

\item{interlace}{Logical value: should the image be interlaced?}
}
\value{
The \code{file} argument, invisibly.
}
\description{
Write a numeric or logical array to a PNG file.
}
\details{
The LodePNG library is used to write a PNG file at the specified path. The
source data should be of logical, integer or numeric mode. Metadata
attributes of the image will be stored where applicable, and may be
overwritten using named arguments. LodePNG will choose the bit depth of the
final image.

Attributes which are currently stored are as follows. In each case an
argument of the appropriate name can be used to override a value stored with
the image.
\describe{
  \item{\code{range}}{A numeric 2-vector giving the extremes of the
    intensity window, i.e. the black and white points. Values outside this
    range will be clipped.}
  \item{\code{background}}{A hexadecimal colour string giving the background
    colour.}
  \item{\code{dpi}}{A numeric 2-vector giving the dots-per-inch resolution
    of the image in each dimension.}
  \item{\code{asp}}{The aspect ratio of the image. Ignored if \code{dpi} is
    present and valid.}
  \item{\code{text}}{A character vector (possibly named) of text strings to
    store in the file. Only ASCII and UTF-8 encoded strings are currently
    supported.}
}
Dimensions are always taken from the image, and cannot be modified here.
}
\seealso{
\code{\link{readPng}} for reading images.
}
