% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-support.R
\name{LMK_ellipse}
\alias{LMK_ellipse}
\title{Confidence Ellipses}
\usage{
LMK_ellipse(
  dat,
  ci = c(67.5, 90, 95, 99),
  linesCol = "black",
  fillCol = "grey",
  smoothness = 20
)
}
\arguments{
\item{dat}{data to be plotted in matrix form [X,Y]}

\item{ci}{Confidence interval to be plotted. Must be one of c(67.5, 90, 95,99)}

\item{linesCol}{Color for the line. Currently takes hsv() format}

\item{fillCol}{color for the fill. Currently only takes hsv() format, set NULL for no fill}

\item{smoothness}{Smoothness for ellipses. Default should be sufficient but is customizable.}
}
\description{
Draw confidence ellipses around data
}
\examples{
set.seed(1)

datx <- rnorm(100,0,1)
daty <- rnorm(100,0,10)

dat <- cbind(datx, daty)

plot(dat)
LMK_ellipse(dat, ci = 90)

}
