% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_mlm.R
\name{g_mlm}
\alias{g_mlm}
\title{Calculates adjusted mlm effect size}
\usage{
g_mlm(
  mod,
  p_const,
  mod_denom = mod,
  r_const = NULL,
  infotype = "expected",
  separate_variances = FALSE,
  ...
)
}
\arguments{
\item{mod}{Fitted model of class lmeStruct (estimated using
\code{nlme::lme()}) or of class glsStruct (estimated using
\code{nlme::gls()}), from which to estimate the numerator of the effect
size.}

\item{p_const}{Vector of constants for calculating numerator of effect size.
Must be the same length as fixed effects in \code{mod}.}

\item{mod_denom}{Fitted model of class lmeStruct (estimated using
\code{nlme::lme()}) or of class glsStruct (estimated using
\code{nlme::gls()}), from which to estimate the denominator of the effect
size. If not otherwise specified, the same model will be used for the
numerator and the denominator calculations.}

\item{r_const}{Vector of constants for calculating denominator of effect
size. Must be the same length as the number of variance component
parameters in \code{mod_denom}.}

\item{infotype}{Type of information matrix. One of \code{"expected"} (the
default), \code{"observed"}, or \code{"average"}.}

\item{separate_variances}{Logical indicating whether to incorporate separate
level-1 variance components in the calculation of the effect size and
standard error for models with a `varIdent()` variance structure. If
\code{TRUE}, make sure the \code{r_const} matches the parameterization of
the variance component as returned by \code{extract_varcomp(mod,
separate_variances = TRUE)}. Default is \code{FALSE}.}

\item{...}{further arguments.}
}
\value{
A list with the following components \tabular{ll}{ \code{p_beta} \tab
  Numerator of effect size \cr \code{r_theta} \tab Squared denominator of
  effect size \cr \code{delta_AB} \tab Unadjusted (mlm) effect size estimate
  \cr \code{nu} \tab Estimated denominator degrees of freedom \cr \code{J_nu}
  \tab Biased correction factor for effect size estimate \cr \code{kappa}
  \tab Scaled standard error of numerator \cr \code{g_AB} \tab Corrected
  effect size estimate \cr \code{SE_g_AB} \tab Approximate standard error
  estimate \cr \code{cnvg_warn} \tab Indicator that model did not converge
  \cr \code{theta} \tab Estimated variance component parameters \cr
  \code{info_inv} \tab Inversed information matrix \cr }
}
\description{
Estimates a standardized mean difference effect size from a
  fitted multi-level model, using restricted or full maximum likelihood
  methods with small-sample correction, as described in Pustejovsky, Hedges,
  & Shadish (2014).
}
\examples{

library(nlme)
data(Bryant2016, package = "lmeInfo")
Bryant2016_RML1 <- lme(fixed = outcome ~ treatment,
                       random = ~ 1 | school/case,
                       correlation = corAR1(0, ~ session | school/case),
                       data = Bryant2016)
Bryant2016_g1 <- g_mlm(Bryant2016_RML1, p_const = c(0,1), r_const = c(1,1,0,1),
                       infotype = "expected")
print(Bryant2016_g1)
summary(Bryant2016_g1)


Bryant2016_RML2 <- lme(fixed = outcome ~ treatment,
                      random = ~ 1 | school/case,
                      correlation = corAR1(0, ~ session | school/case),
                      weights = varIdent(form = ~ 1 | treatment),
                      data = Bryant2016)
Bryant_g <- g_mlm(Bryant2016_RML2, p_const = c(0,1), r_const = c(1,1,0,0,1))
Bryant_g_baseline <- g_mlm(Bryant2016_RML2,
                           p_const = c(0,1),
                           r_const = c(1,1,0,1,0),
                           separate_variances = TRUE)
Bryant_g_treatment <- g_mlm(Bryant2016_RML2,
                            p_const = c(0,1),
                            r_const = c(1,1,0,0,1),
                            separate_variances = TRUE)
print(Bryant_g)
print(Bryant_g_baseline)
print(Bryant_g_treatment)


}
\references{
Pustejovsky, J. E., Hedges, L. V., & Shadish, W. R. (2014).
  Design-comparable effect sizes in multiple baseline designs: A general
  modeling framework. \emph{Journal of Educational and Behavioral Statistics,
  39}(4), 211-227. \doi{10.3102/1076998614547577}
}
