% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmdu.R
\name{lmdu}
\alias{lmdu}
\title{Logistic (Restricted) MDU}
\usage{
lmdu(
  Y,
  f = NULL,
  X = NULL,
  S = 2,
  start = "svd",
  maxiter = 65536,
  dcrit = 1e-06
)
}
\arguments{
\item{Y}{An N times R binary matrix  .}

\item{f}{Vector with frequencies of response patterns in Y (only applicable if (X = NULL))}

\item{X}{An N by P matrix with predictor variables}

\item{S}{Positive number indicating the dimensionality of the solution}

\item{start}{Either user provided starting values (start should be a list with U and V) or a way to compute starting values (choices: random, svd, ca)}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
deviance
\item{call}{Call to the function}
\item{Yoriginal}{Matrix Y from input}
\item{Y}{Matrix Y from input}
\item{f}{frequencies of rows of Y}
\item{Xoriginal}{Matrix X from input}
\item{X}{Scaled X matrix}
\item{mx}{Mean values of X}
\item{sdx}{Standard deviations of X}
\item{ynames}{Variable names of responses}
\item{xnames}{Variable names of predictors}
\item{probabilities}{Estimated values of Y}
\item{m}{main effects}
\item{U}{matrix with coordinates for row-objects}
\item{B}{matrix with regression weight (U = XB)}
\item{V}{matrix with vectors for items/responses}
\item{iter}{number of main iterations from the MM algorithm}
\item{deviance}{value of the deviance at convergence}
\item{npar}{number of estimated parameters}
\item{AIC}{Akaike's Information Criterion}
\item{BIC}{Bayesian Information Criterion}
}
\description{
This function runs:
logistic multidimensional unfolding (if X = NULL)
logistic restricted multidimensional unfolding (if X != NULL)
}
\examples{
\dontrun{
data(dataExample_lmdu)
Y = as.matrix(dataExample_lmdu[ , 1:8])
X = as.matrix(dataExample_lmdu[ , 9:13])
# unsupervised
output = lmdu(Y = Y, S = 2)
# supervised
output2 = lmdu(Y = Y, X = X, S = 2)
}

}
