% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{rocSVM}
\alias{rocSVM}
\title{Receiver Operating Characteristic curve (ROC curve)}
\usage{
rocSVM(x, y, ..., weight_steps = 9, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{weight_steps}{indicates how many weights between \code{min_weight} and
\code{max_weight} will be used}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine provides several points on the ROC curve by
solving multiple weighted binary classification problems.
It is only suitable to binary classification data.
}
\details{
Please look at the demo-vignette (\code{vignette('demo')}) for more examples.
The labels should only have value \code{c(1,-1)}.

\code{min_weight}, \code{max_weight}, \code{weight_steps}: you might have to define
which weighted classification problems will be considered.
The choice is usually a bit tricky. Good luck ...
}
\examples{
\dontrun{
banana <- liquidData('banana-bc')
model <- rocSVM(Y ~ ., banana$train, display=1)
plotROC(model,banana$test)

## a worked example can be seen at
vignette("demo",package="liquidSVM")
}
 
}
\seealso{
\code{\link{plotROC}}
}

