% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lingmatch.R
\name{lma_lspace}
\alias{lma_lspace}
\title{Latent Semantic Space (Embeddings) Operations}
\usage{
lma_lspace(dtm = "", space, map.space = TRUE, fill.missing = FALSE,
  term.map = NULL, dim.cutoff = 0.5, keep.dim = FALSE,
  use.scan = FALSE, dir = getOption("lingmatch.lspace.dir"))
}
\arguments{
\item{dtm}{A matrix with terms as column names, or a character vector of terms to be extracted
from a specified space. If this is of length 1 and \code{space} is missing, it will be treated
as \code{space}.}

\item{space}{A matrix with terms as rownames. If missing, this will be the right singular vectors
of a singular value decomposition of \code{dtm}. If a character, a file matching the character
will be searched for in \code{dir} (e.g., \code{space = 'google'}). If a file is not found and
the character matches one of the \href{https://osf.io/489he/wiki/home}{available spaces}, you
will be given the option to download it, as handled by \code{\link{download.lspace}}.
If \code{dtm} is missing, the entire space will be loaded and returned.}

\item{map.space}{Logical: if \code{FALSE}, the original vectors of \code{space} for terms
found in \code{dtm} are returned. Otherwise \code{dtm} \code{\%*\%} \code{space} is returned,
excluding uncommon columns of \code{dtm} and rows of \code{space}.}

\item{fill.missing}{Logical: if \code{TRUE} and terms are being extracted from a space, includes
terms not found in the space as rows of 0s, such that the returned matrix will have a row
for every requested term.}

\item{term.map}{A matrix with \code{space} as a column name, terms as row names, and indices of
the terms in the given space as values, or a numeric vector of indices with terms as names, or
a character vector or terms corresponding to rows of the space. This is used instead of reading
in an "_terms.txt" file corresponding to a \code{space} entered as a character (the name of a
space file).}

\item{dim.cutoff}{If a \code{space} is calculated, this will be used to decide on the number of
dimensions to be retained: \code{cumsum(d) / sum(d) < dim.cutoff}, where \code{d} is a vector
of singular values of \code{dtm} (i.e., \code{svd(dtm)$d}). The default is \code{.5}; lower
cutoffs result in fewer dimensions.}

\item{keep.dim}{Logical: if \code{TRUE}, and a space is being calculated from the input, a matrix
in the same dimensions as \code{dtm} is returned. Otherwise, a matrix with terms as rows and
dimensions as columns is returned.}

\item{use.scan}{Logical: if \code{TRUE}, reads in the rows of \code{space} with \code{\link{scan}}.}

\item{dir}{Path to a folder containing spaces. \cr
Set a session default with \code{options(lingmatch.lspace.dir = 'desired/path')}.}
}
\value{
A matrix or sparse matrix with either (a) a row per term and column per latent dimension (a latent
space, either calculated from the input, or retrieved when \code{map.space = FALSE}), (b) a row per document
and column per latent dimension (when a dtm is mapped to a space), or (c) a row per document and
column per term (when a space is calculated and \code{keep.dim = TRUE}).
}
\description{
Map a document-term matrix onto a latent semantic space, extract terms from a
latent semantic space (if \code{dtm} is a character vector, or \code{map.space =} \code{FALSE}),
or perform a singular value decomposition of a document-term matrix (if \code{dtm} is a matrix
and \code{space} is missing).
}
\note{
A traditional latent semantic space is a selection of right singular vectors from the singular
value decomposition of a dtm (\code{svd(dtm)$v[, 1:k]}, where \code{k} is the selected number of
dimensions, decided here by \code{dim.cutoff}).

Mapping a new dtm into a latent semantic space consists of multiplying common terms:
\code{dtm[, ct]} \code{\%*\% space[ct, ]}, where \code{ct} \code{=} \code{colnames(dtm)[colnames(dtm)}
\code{\%in\%} \code{rownames(space)]} -- the terms common between the dtm and the space. This
results in a matrix with documents as rows, and dimensions as columns, replacing terms.
}
\examples{
text = c(
  paste(
    "Hey, I like kittens. I think all kinds of cats really are just the",
    "best pet ever."
  ),
  paste(
    "Oh year? Well I really like cars. All the wheels and the turbos...",
    "I think that's the best ever."
  ),
  paste(
    "You know what? Poo on you. Cats, dogs, rabbits -- you know, living",
    "creatures... to think you'd care about anything else!"
  ),
  paste(
    "You can stick to your opinion. You can be wrong if you want. You know",
    "what life's about? Supercharging, diesel guzzling, exhaust spewing,",
    "piston moving ignitions."
  )
)

dtm = lma_dtm(text)

# calculate a latent semantic space from the example text
lss = lma_lspace(dtm)

# show that document similarities between the truncated and full space are the same
spaces = list(
  full = lma_lspace(dtm, keep.dim = TRUE),
  truncated = lma_lspace(dtm, lss)
)
sapply(spaces, lma_simets, metric = 'cosine')

\dontrun{

# specify a directory containing spaces,
# or where you would like to download spaces
space_dir = '~/Latent Semantic Spaces'

# map to a pretrained space
ddm = lma_lspace(dtm, '100k', dir = space_dir)

# load the matching subset of the space
# without mapping
lss_100k_part = lma_lspace(colnames(dtm), '100k', dir = space_dir)

## or
lss_100k_part = lma_lspace(dtm, '100k', map.space = FALSE, dir = space_dir)

# load the full space
lss_100k = lma_lspace('100k', dir = space_dir)

## or
lss_100k = lma_lspace(space = '100k', dir = space_dir)

}
}
\seealso{
Other Latent Semantic Space functions: 
\code{\link{download.lspace}()},
\code{\link{select.lspace}()},
\code{\link{standardize.lspace}()}
}
\concept{Latent Semantic Space functions}
