% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqAGP.R
\name{augment.lineqAGP}
\alias{augment.lineqAGP}
\title{Augmenting Method for the \code{"lineqAGP"} S3 Class}
\usage{
\method{augment}{lineqAGP}(x, ...)
}
\arguments{
\item{x}{an object with class \code{lineqGP}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An expanded \code{"lineqGP"} object with the following additional elements.
\item{Phi}{a matrix corresponding to the hat basis functions.
The basis functions are indexed by rows.}
\item{Gamma}{the covariance matrix of the Gassian vector \eqn{\boldsymbol{\xi}}{\xi}.}
\item{(Lambda,lb,ub)}{the linear system of inequalities.}
\item{...}{further parameters passed to or from other methods.}
}
\description{
Augmenting method for the \code{"lineqAGP"} S3 class.
}
\details{
Some paramaters of the finite-dimensional GP with linear inequality
constraints are computed. Here, \eqn{\boldsymbol{\xi}}{\xi} is a centred Gaussian
vector with covariance \eqn{\boldsymbol{\Gamma}}{\Gamma}, s.t.
\eqn{\boldsymbol{\Phi} \boldsymbol{\xi} = \boldsymbol{y}}{\Phi \xi = y}
(interpolation constraints) and
\eqn{\boldsymbol{l} \leq \boldsymbol{\Lambda} \boldsymbol{\xi} \leq \boldsymbol{u}}{lb \le \Lambda \xi \le ub}
(inequality constraints).
}
\examples{
# creating the model
d <- 2
fun1 <- function(x) return(4*(x-0.5)^2)
fun2 <- function(x) return(2*x)
targetFun <- function(x) return(fun1(x[, 1]) + fun1(x[, 2])) 
xgrid <- expand.grid(seq(0, 1, 0.01), seq(0, 1, 0.01))
ygrid <- targetFun(xgrid)
xdesign <- rbind(c(0.5, 0), c(0.5, 0.5), c(0.5, 1), c(0, 0.5), c(1, 0.5))
ydesign <- targetFun(xdesign)
model <- create(class = "lineqAGP", x = xdesign, y = ydesign,
                constrType = c("convexity", "monotonicity"))

# updating and expanding the model
model$localParam$m <- rep(50, d)
model$kernParam[[1]]$par <- c(1, 0.2)
model$kernParam[[2]]$par <- c(1, 0.2)
model$nugget <- 1e-9
model$varnoise <- 1e-5
model <- augment(model)
str(model)

}
\references{
Lopez-Lopera, A. F., Bachoc, F., Durrande, N., and Roustant, O. (2017),
"Finite-dimensional Gaussian approximation with linear inequality constraints".
\emph{ArXiv e-prints}
\href{https://arxiv.org/abs/1710.07453}{[link]}
}
\seealso{
\code{\link{create.lineqAGP}}, \code{\link{predict.lineqAGP}},
         \code{\link{simulate.lineqAGP}}
}
\author{
A. F. Lopez-Lopera.
}
