% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_tags.R
\name{set_tags}
\alias{set_tags}
\title{Changes tags of a linelist object}
\usage{
set_tags(x, ..., allow_extra = FALSE)
}
\arguments{
\item{x}{a \code{data.frame} or a \code{tibble} containing case line list data, with
cases in rows and variables in columns}

\item{...}{a series of tags provided as \code{tag_name = "column_name"}, where
\code{tag_name} indicates any of the known variables listed in 'Details';
alternatively, a named \code{list} of variables to be tagged, where names
indicate the types of variable (to be selected from \code{\link[=tags_names]{tags_names()}}), and
values indicate their name in the input \code{data.frame}; see details for a
list of known variable types and their expected content}

\item{allow_extra}{a \code{logical} indicating if additional data tags not
currently recognized by \code{linelist} should be allowed; if \code{FALSE}, unknown
tags will trigger an error}
}
\value{
The function returns a \code{linelist} object.
}
\description{
This function changes the \code{tags} of a \code{linelist} object, using the same
syntax as the constructor \code{\link[=make_linelist]{make_linelist()}}. If some of the default tags are
missing, they will be added to the final object.
}
\examples{

if (require(outbreaks)) {
  ## create a linelist
  x <- make_linelist(measles_hagelloch_1861, date_onset = "date_of_rash")
  tags(x)

  ## add new tags and fix an existing one
  x <- set_tags(x,
    age = "age",
    gender = "gender",
    date_onset = "date_of_prodrome"
  )
  tags(x)

  ## add non-default tags using allow_extra
  x <- set_tags(x, severe = "complications", allow_extra = TRUE)
  tags(x)

  ## remove tags by setting them to NULL
  old_tags <- tags(x)
  x <- set_tags(x, age = NULL, gender = NULL)
  tags(x)

  ## setting tags providing a list (used to restore old tags here)
  x <- set_tags(x, old_tags)
  tags(x)
}

}
\seealso{
\code{\link[=make_linelist]{make_linelist()}} to create a \code{linelist} object
}
\author{
Thibaut Jombart \email{thibaut@data.org}
}
