% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{lgb.Dataset.create.valid}
\alias{lgb.Dataset.create.valid}
\title{Construct validation data}
\usage{
lgb.Dataset.create.valid(dataset, data, info = list(), ...)
}
\arguments{
\item{dataset}{\code{lgb.Dataset} object, training data}

\item{data}{a \code{matrix} object, a \code{dgCMatrix} object or a character representing a filename}

\item{info}{a list of information of the \code{lgb.Dataset} object}

\item{...}{other information to pass to \code{info}.}
}
\value{
constructed dataset
}
\description{
Construct validation data according to training data
}
\examples{
\donttest{
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "lightgbm")
test <- agaricus.test
dtest <- lgb.Dataset.create.valid(dtrain, test$data, label = test$label)
}
}
