/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/Bayesian.h>
#include <so/private/Bayesian.h>

so_Bayesian *so_Bayesian_new()
{
	so_Bayesian *object = calloc(sizeof(so_Bayesian), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_Bayesian *so_Bayesian_copy(so_Bayesian *self)
{
	so_Bayesian *dest = so_Bayesian_new();
	if (dest) {
		if (self->PosteriorMean) {
			dest->PosteriorMean = so_Table_copy(self->PosteriorMean);
			if (!dest->PosteriorMean) {
				so_Bayesian_free(dest);
				return NULL;
			}
		}
		if (self->PosteriorMedian) {
			dest->PosteriorMedian = so_Table_copy(self->PosteriorMedian);
			if (!dest->PosteriorMedian) {
				so_Bayesian_free(dest);
				return NULL;
			}
		}
		if (self->PosteriorMode) {
			dest->PosteriorMode = so_Table_copy(self->PosteriorMode);
			if (!dest->PosteriorMode) {
				so_Bayesian_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_Bayesian_free(so_Bayesian *self)
{
	if (self) {
		so_Table_unref(self->PosteriorMean);
		so_Table_unref(self->PosteriorMedian);
		so_Table_unref(self->PosteriorMode);
		free(self);
	}
}

void so_Bayesian_ref(so_Bayesian *self)
{
	self->reference_count++;
}

void so_Bayesian_unref(so_Bayesian *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_Bayesian_free(self);
		}
	}
}

so_Table *so_Bayesian_get_PosteriorMean(so_Bayesian *self)
{
	return self->PosteriorMean;
}

so_Table *so_Bayesian_get_PosteriorMedian(so_Bayesian *self)
{
	return self->PosteriorMedian;
}

so_Table *so_Bayesian_get_PosteriorMode(so_Bayesian *self)
{
	return self->PosteriorMode;
}

void so_Bayesian_set_PosteriorMean(so_Bayesian *self, so_Table *value)
{
	so_Table_unref(self->PosteriorMean);
	self->PosteriorMean = value;
}

void so_Bayesian_set_PosteriorMedian(so_Bayesian *self, so_Table *value)
{
	so_Table_unref(self->PosteriorMedian);
	self->PosteriorMedian = value;
}

void so_Bayesian_set_PosteriorMode(so_Bayesian *self, so_Table *value)
{
	so_Table_unref(self->PosteriorMode);
	self->PosteriorMode = value;
}

so_Table *so_Bayesian_create_PosteriorMean(so_Bayesian *self)
{
	so_Table *obj = so_Table_new("PosteriorMean");
	if (obj) {
		self->PosteriorMean = obj;
	}
	return obj;
}

so_Table *so_Bayesian_create_PosteriorMedian(so_Bayesian *self)
{
	so_Table *obj = so_Table_new("PosteriorMedian");
	if (obj) {
		self->PosteriorMedian = obj;
	}
	return obj;
}

so_Table *so_Bayesian_create_PosteriorMode(so_Bayesian *self)
{
	so_Table *obj = so_Table_new("PosteriorMode");
	if (obj) {
		self->PosteriorMode = obj;
	}
	return obj;
}

int so_Bayesian_xml(so_Bayesian *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->PosteriorMean || self->PosteriorMedian || self->PosteriorMode) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "Bayesian");
		if (rc < 0) return 1;
		if (self->PosteriorMean) {
			rc = so_Table_xml(self->PosteriorMean, writer, "PosteriorMean");
			if (rc != 0) return rc;
		}
		if (self->PosteriorMedian) {
			rc = so_Table_xml(self->PosteriorMedian, writer, "PosteriorMedian");
			if (rc != 0) return rc;
		}
		if (self->PosteriorMode) {
			rc = so_Table_xml(self->PosteriorMode, writer, "PosteriorMode");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_Bayesian_start_element(so_Bayesian *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_PosteriorMean) {
		int fail = so_Table_start_element(self->PosteriorMean, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PosteriorMedian) {
		int fail = so_Table_start_element(self->PosteriorMedian, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_PosteriorMode) {
		int fail = so_Table_start_element(self->PosteriorMode, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "PosteriorMean") == 0) {
		so_Table *PosteriorMean = so_Bayesian_create_PosteriorMean(self);
		if (!PosteriorMean) {
			return 1;
		}
		self->in_PosteriorMean = 1;
	} else if (strcmp(localname, "PosteriorMedian") == 0) {
		so_Table *PosteriorMedian = so_Bayesian_create_PosteriorMedian(self);
		if (!PosteriorMedian) {
			return 1;
		}
		self->in_PosteriorMedian = 1;
	} else if (strcmp(localname, "PosteriorMode") == 0) {
		so_Table *PosteriorMode = so_Bayesian_create_PosteriorMode(self);
		if (!PosteriorMode) {
			return 1;
		}
		self->in_PosteriorMode = 1;
	}
	return 0;
}

void so_Bayesian_end_element(so_Bayesian *self, const char *localname)
{
	if (strcmp(localname, "PosteriorMean") == 0 && self->in_PosteriorMean) {
		self->in_PosteriorMean = 0;
	} else if (strcmp(localname, "PosteriorMedian") == 0 && self->in_PosteriorMedian) {
		self->in_PosteriorMedian = 0;
	} else if (strcmp(localname, "PosteriorMode") == 0 && self->in_PosteriorMode) {
		self->in_PosteriorMode = 0;
	} else if (self->in_PosteriorMean) {
		so_Table_end_element(self->PosteriorMean, localname);
	} else if (self->in_PosteriorMedian) {
		so_Table_end_element(self->PosteriorMedian, localname);
	} else if (self->in_PosteriorMode) {
		so_Table_end_element(self->PosteriorMode, localname);
	}
}

int so_Bayesian_characters(so_Bayesian *self, const char *ch, int len)
{
	if (self->in_PosteriorMean) {
		int fail = so_Table_characters(self->PosteriorMean, ch, len);
		if (fail) return 1;
	} else if (self->in_PosteriorMedian) {
		int fail = so_Table_characters(self->PosteriorMedian, ch, len);
		if (fail) return 1;
	} else if (self->in_PosteriorMode) {
		int fail = so_Table_characters(self->PosteriorMode, ch, len);
		if (fail) return 1;
	}
	return 0;
}
