/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/ExternalFile.h>
#include <so/private/ExternalFile.h>

so_ExternalFile *so_ExternalFile_new()
{
	so_ExternalFile *object = calloc(sizeof(so_ExternalFile), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_ExternalFile *so_ExternalFile_copy(so_ExternalFile *self)
{
	so_ExternalFile *dest = so_ExternalFile_new();
	if (dest) {
		if (self->oid) {
			dest->oid = pharmml_strdup(self->oid);
			if (!dest->oid) {
				so_ExternalFile_free(dest);
				return NULL;
			}
		}
		if (self->Description) {
			dest->Description = pharmml_strdup(self->Description);
			if (!dest->Description) {
				so_ExternalFile_free(dest);
				return NULL;
			}
		}
		if (self->path) {
			dest->path = pharmml_strdup(self->path);
			if (!dest->path) {
				so_ExternalFile_free(dest);
				return NULL;
			}
		}
		if (self->format) {
			dest->format = pharmml_strdup(self->format);
			if (!dest->format) {
				so_ExternalFile_free(dest);
				return NULL;
			}
		}
		if (self->delimiter) {
			dest->delimiter = pharmml_strdup(self->delimiter);
			if (!dest->delimiter) {
				so_ExternalFile_free(dest);
				return NULL;
			}
		}
		if (self->num_MissingData) {
			dest->MissingData = calloc(self->num_MissingData * sizeof(so_MissingData *), 1);
			if (!dest->MissingData) {
				so_ExternalFile_free(dest);
				return NULL;
			}
			dest->num_MissingData = self->num_MissingData;
			for (int i = 0; i < self->num_MissingData; i++) {
				dest->MissingData[i] = so_MissingData_copy(self->MissingData[i]);
				if (!dest->MissingData[i]) {
					so_ExternalFile_free(dest);
					return NULL;
				}
			}
		}
	}

	return dest;
}

void so_ExternalFile_free(so_ExternalFile *self)
{
	if (self) {
		free(self->Description);
		free(self->path);
		free(self->format);
		free(self->delimiter);
		for(int i = 0; i < self->num_MissingData; i++) {
			so_MissingData_unref(self->MissingData[i]);
		}
		free(self->MissingData);
		if (self->oid) free(self->oid);
		free(self);
	}
}

void so_ExternalFile_ref(so_ExternalFile *self)
{
	self->reference_count++;
}

void so_ExternalFile_unref(so_ExternalFile *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_ExternalFile_free(self);
		}
	}
}

char *so_ExternalFile_get_oid(so_ExternalFile *self)
{
	return self->oid;
}

char *so_ExternalFile_get_Description(so_ExternalFile *self)
{
	return self->Description;
}

char *so_ExternalFile_get_path(so_ExternalFile *self)
{
	return self->path;
}

char *so_ExternalFile_get_format(so_ExternalFile *self)
{
	return self->format;
}

char *so_ExternalFile_get_delimiter(so_ExternalFile *self)
{
	return self->delimiter;
}

so_MissingData *so_ExternalFile_get_MissingData(so_ExternalFile *self, int number)
{
	return self->MissingData[number];
}

int so_ExternalFile_get_number_of_MissingData(so_ExternalFile *self)
{
	return self->num_MissingData;
}

int so_ExternalFile_set_oid(so_ExternalFile *self, char *value)
{
	if (!value) {
		self->oid = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->oid);
		self->oid = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_ExternalFile_set_Description(so_ExternalFile *self, char *value)
{
	if (!value) {
		self->Description = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->Description);
		self->Description = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_ExternalFile_set_path(so_ExternalFile *self, char *value)
{
	if (!value) {
		self->path = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->path);
		self->path = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_ExternalFile_set_format(so_ExternalFile *self, char *value)
{
	if (!value) {
		self->format = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->format);
		self->format = new_value;
		return 0;
	} else {
		return 1;
	}
}

int so_ExternalFile_set_delimiter(so_ExternalFile *self, char *value)
{
	if (!value) {
		self->delimiter = value;
		return 0;
	}
	char *new_value = pharmml_strdup(value);
	if (new_value) {
		free(self->delimiter);
		self->delimiter = new_value;
		return 0;
	} else {
		return 1;
	}
}

so_MissingData *so_ExternalFile_create_MissingData(so_ExternalFile *self)
{
	so_MissingData *obj = so_MissingData_new();
	if (obj) {
		so_MissingData **newblock = realloc(self->MissingData, (self->num_MissingData + 1) * sizeof(so_MissingData *));
		if (newblock) {
			self->MissingData = newblock;
			self->MissingData[self->num_MissingData] = obj;
			self->num_MissingData++;
		} else {
			so_MissingData_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

int so_ExternalFile_add_MissingData(so_ExternalFile *self, so_MissingData *child)
{
	so_MissingData **new_array = realloc(self->MissingData, (self->num_MissingData + 1) * sizeof(so_MissingData *));
	if (!new_array) {
		return 1;
	}
	self->MissingData = new_array;
	self->MissingData[self->num_MissingData] = child;
	self->num_MissingData++;
	return 0;
}

int so_ExternalFile_remove_MissingData(so_ExternalFile *self, int index)
{
	int size = self->num_MissingData;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->MissingData);
		self->MissingData = NULL;
		return 0;
	}
	so_MissingData *final = self->MissingData[size - 1];
	so_MissingData *remove = self->MissingData[index];
	so_MissingData **new_array = realloc(self->MissingData, (self->num_MissingData - 1) * sizeof(so_MissingData *));
	if (!new_array) {
		return 1;
	}
	self->num_MissingData--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->MissingData[i] = self->MissingData[i + 1];
	}
	self->MissingData[size - 2] = final;
	so_MissingData_unref(remove);
	return 0;
}

int so_ExternalFile_xml(so_ExternalFile *self, xmlTextWriterPtr writer, char *element_name)
{
	int rc;
	if (self->Description || self->path || self->format || self->delimiter || self->MissingData || self->oid) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST element_name);
		if (rc < 0) return 1;
		if (self->oid) {
			rc = xmlTextWriterWriteAttribute(writer, BAD_CAST "oid", BAD_CAST self->oid);
			if (rc < 0) return 1;
		}
		if (self->Description) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ct:Description", BAD_CAST self->Description);
			if (rc < 0) return 1;
		}
		if (self->path) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ds:path", BAD_CAST self->path);
			if (rc < 0) return 1;
		}
		if (self->format) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ds:format", BAD_CAST self->format);
			if (rc < 0) return 1;
		}
		if (self->delimiter) {
			rc = xmlTextWriterWriteElement(writer, BAD_CAST "ds:delimiter", BAD_CAST self->delimiter);
			if (rc < 0) return 1;
		}
		if (self->MissingData) {
			for (int i = 0; i < self->num_MissingData; i++) {
				rc = so_MissingData_xml(self->MissingData[i], writer);
				if (rc != 0) return 1;
			}
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_ExternalFile_start_element(so_ExternalFile *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_MissingData) {
		int fail = so_MissingData_start_element(self->MissingData[self->num_MissingData - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "Description") == 0) {
		self->in_Description = 1;
	} else if (strcmp(localname, "path") == 0) {
		self->in_path = 1;
	} else if (strcmp(localname, "format") == 0) {
		self->in_format = 1;
	} else if (strcmp(localname, "delimiter") == 0) {
		self->in_delimiter = 1;
	} else if (strcmp(localname, "MissingData") == 0) {
		so_MissingData *MissingData = so_MissingData_new();
		if (!MissingData) {
			return 1;
		}
		int fail = so_MissingData_init_attributes(MissingData, nb_attributes, attributes);
		if (fail) {
			so_MissingData_free(MissingData);
			return 1;
		}
		fail = so_ExternalFile_add_MissingData(self, MissingData);
		if (fail) {
			so_MissingData_free(MissingData);
			return 1;
		}
		self->in_MissingData = 1;
	}
	return 0;
}

void so_ExternalFile_end_element(so_ExternalFile *self, const char *localname)
{
	if (strcmp(localname, "Description") == 0 && self->in_Description) {
		self->in_Description = 0;
	} else if (strcmp(localname, "path") == 0 && self->in_path) {
		self->in_path = 0;
	} else if (strcmp(localname, "format") == 0 && self->in_format) {
		self->in_format = 0;
	} else if (strcmp(localname, "delimiter") == 0 && self->in_delimiter) {
		self->in_delimiter = 0;
	} else if (strcmp(localname, "MissingData") == 0 && self->in_MissingData) {
		self->in_MissingData = 0;
	} else if (self->in_MissingData) {
		so_MissingData_end_element(self->MissingData[self->num_MissingData - 1], localname);
	}
}

int so_ExternalFile_characters(so_ExternalFile *self, const char *ch, int len)
{
	if (self->in_Description) {
		self->Description = pharmml_strndup(ch, len);
		if (!self->Description) {
			return 1;
		}
	} else if (self->in_path) {
		self->path = pharmml_strndup(ch, len);
		if (!self->path) {
			return 1;
		}
	} else if (self->in_format) {
		self->format = pharmml_strndup(ch, len);
		if (!self->format) {
			return 1;
		}
	} else if (self->in_delimiter) {
		self->delimiter = pharmml_strndup(ch, len);
		if (!self->delimiter) {
			return 1;
		}
	} else if (self->in_MissingData) {
		int fail = so_MissingData_characters(self->MissingData[self->num_MissingData - 1], ch, len);
		if (fail) return 1;
	}
	return 0;
}

int so_ExternalFile_init_attributes(so_ExternalFile *self, int nb_attributes, const char **attributes)
{
	unsigned int index = 0;
	for (int i = 0; i < nb_attributes; i++, index += 5) {
		const char *localname = attributes[index];
		const char *valueBegin = attributes[index + 3];
		const char *valueEnd = attributes[index + 4];

		if (strcmp(localname, "oid") == 0) {
			self->oid = pharmml_strndup(valueBegin, valueEnd - valueBegin);
			if (!self->oid) {
				return 1;
			}
		}
	}
	return 0;
}
