/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#include <R.h>
#include <Rdefines.h>
#include <so.h>
#include "soc.h"

SEXP r_so_SOBlock_new()
{
	so_SOBlock *obj = so_SOBlock_new();
	if (!obj) {
		error("Failed to create so_SOBlock object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_copy(SEXP self)
{
	so_SOBlock *obj = so_SOBlock_copy(R_ExternalPtrAddr(self));
	if (!obj) {
		error("Failed to copy so_SOBlock object");
	}
	return R_MakeExternalPtr(obj, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_free(SEXP self)
{
	so_SOBlock_free(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SOBlock_ref(SEXP self)
{
	so_SOBlock_ref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SOBlock_unref(SEXP self)
{
	so_SOBlock_unref(R_ExternalPtrAddr(self));
	return R_NilValue;
}

SEXP r_so_SOBlock_get_ToolSettings(SEXP self)
{
	so_ToolSettings *child = so_SOBlock_get_ToolSettings(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_ToolSettings(SEXP self, SEXP child)
{
	so_SOBlock_set_ToolSettings(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_ToolSettings(SEXP self)
{
	so_ToolSettings *child = so_SOBlock_create_ToolSettings(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_RawResults(SEXP self)
{
	so_RawResults *child = so_SOBlock_get_RawResults(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_RawResults(SEXP self, SEXP child)
{
	so_SOBlock_set_RawResults(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_RawResults(SEXP self)
{
	so_RawResults *child = so_SOBlock_create_RawResults(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_TaskInformation(SEXP self)
{
	so_TaskInformation *child = so_SOBlock_get_TaskInformation(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_TaskInformation(SEXP self, SEXP child)
{
	so_SOBlock_set_TaskInformation(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_TaskInformation(SEXP self)
{
	so_TaskInformation *child = so_SOBlock_create_TaskInformation(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_Estimation(SEXP self)
{
	so_Estimation *child = so_SOBlock_get_Estimation(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_Estimation(SEXP self, SEXP child)
{
	so_SOBlock_set_Estimation(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_Estimation(SEXP self)
{
	so_Estimation *child = so_SOBlock_create_Estimation(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_Simulation(SEXP self)
{
	so_Simulation *child = so_SOBlock_get_Simulation(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_Simulation(SEXP self, SEXP child)
{
	so_SOBlock_set_Simulation(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_Simulation(SEXP self)
{
	so_Simulation *child = so_SOBlock_create_Simulation(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_ModelDiagnostic(SEXP self)
{
	so_ModelDiagnostic *child = so_SOBlock_get_ModelDiagnostic(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_ModelDiagnostic(SEXP self, SEXP child)
{
	so_SOBlock_set_ModelDiagnostic(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_ModelDiagnostic(SEXP self)
{
	so_ModelDiagnostic *child = so_SOBlock_create_ModelDiagnostic(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_OptimalDesign(SEXP self)
{
	so_OptimalDesign *child = so_SOBlock_get_OptimalDesign(R_ExternalPtrAddr(self));
	SEXP result = R_MakeExternalPtr(child, R_NilValue, R_NilValue);
	return result;
}

SEXP r_so_SOBlock_set_OptimalDesign(SEXP self, SEXP child)
{
	so_SOBlock_set_OptimalDesign(R_ExternalPtrAddr(self), R_ExternalPtrAddr(child));
	return R_NilValue;
}

SEXP r_so_SOBlock_create_OptimalDesign(SEXP self)
{
	so_OptimalDesign *child = so_SOBlock_create_OptimalDesign(R_ExternalPtrAddr(self));
	return R_MakeExternalPtr(child, R_NilValue, R_NilValue);
}

SEXP r_so_SOBlock_get_blkId(SEXP self)
{
	char *value = so_SOBlock_get_blkId(R_ExternalPtrAddr(self));

	SEXP result;

	if (value) {
		result = PROTECT(NEW_STRING(1));
		SET_STRING_ELT(result, 0, mkChar(value));

		UNPROTECT(1);
	} else {
		result = R_NilValue;
	}
	return result;
}

SEXP r_so_SOBlock_set_blkId(SEXP self, SEXP string)
{
	char *c_string = (char *) CHAR(STRING_ELT(string, 0));
	int fail = so_SOBlock_set_blkId(R_ExternalPtrAddr(self), c_string);
	if (fail) {
		error("so_SOBlock_set_blkId failed");
	}

	return R_NilValue;
}

