% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_tools.R
\name{browse_cran}
\alias{browse_cran}
\title{Search for CRAN packages by keyword/regex}
\usage{
browse_cran(query, fuzzy = FALSE, echo = TRUE, ignore.case = TRUE)
}
\arguments{
\item{query}{(Character) A string to \code{grep()} for.}

\item{fuzzy}{(Logical) If \code{TRUE}, enables fuzzy orderless matching. Every word in
\code{query} (i.e. every group of characters separated with a space) will be wrapped
with a lookaround \code{(?=*KEYWORD)}. This will match keywords regardless
of the order in which those words appear.}

\item{echo}{(Logical) If \code{TRUE}, print the results to the console.}

\item{ignore.case}{(Logical) If \code{TRUE}, ignore upper/lowercase differences while
searching.}
}
\value{
Invisibly returns a dataframe of the packages that matched the query
together with their descriptions.
}
\description{
Inspired by my mysterious inability to remember what the ColorBrewer package is
actually called.
}
\examples{
\donttest{
browse_cran("colorbrewer")

#> RColorBrewer 
#>     Provides color schemes for maps (and other graphics) designed by Cynthia 
#>     Brewer as described at http://colorbrewer2.org 
#> 
#> Redmonder 
#>     Provide color schemes for maps (and other graphics) based on the color 
#>     palettes of several Microsoft(r) products. Forked from 'RColorBrewer' 
#>     v1.1-2. 
}

}
